/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.AggregationInitializationException;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.easysearch.search.internal.ContextIndexSearcher;
import org.easysearch.search.internal.SearchContext;

public class FiltersAggregatorFactory
extends AggregatorFactory {
    private final String[] keys;
    private final Query[] filters;
    private Weight[] weights;
    private final boolean keyed;
    private final boolean otherBucket;
    private final String otherBucketKey;

    public FiltersAggregatorFactory(String name, List<FiltersAggregator.KeyedFilter> filters, boolean keyed, boolean otherBucket, String otherBucketKey, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        this.keyed = keyed;
        this.otherBucket = otherBucket;
        this.otherBucketKey = otherBucketKey;
        this.keys = new String[filters.size()];
        this.filters = new Query[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FiltersAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            this.filters[i] = keyedFilter.filter().toQuery(queryShardContext);
        }
    }

    public Weight[] getWeights(SearchContext searchContext) {
        if (this.weights == null) {
            try {
                ContextIndexSearcher contextSearcher = searchContext.searcher();
                this.weights = new Weight[this.filters.length];
                for (int i = 0; i < this.filters.length; ++i) {
                    this.weights[i] = contextSearcher.createWeight(contextSearcher.rewrite(this.filters[i]), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                }
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialse filters for aggregation [" + this.name() + "]", e);
            }
        }
        return this.weights;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new FiltersAggregator(this.name, this.factories, this.keys, () -> this.getWeights(searchContext), this.keyed, this.otherBucket ? this.otherBucketKey : null, searchContext, parent, cardinality, metadata);
    }
}

