/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import org.apache.lucene.util.packed.PackedInts;
import org.easysearch.search.aggregations.metrics.AbstractCardinalityAlgorithm;

public abstract class AbstractLinearCounting
extends AbstractCardinalityAlgorithm {
    private static final int P2 = 25;

    public AbstractLinearCounting(int precision) {
        super(precision);
    }

    protected abstract int addEncoded(long var1, int var3);

    protected abstract int size(long var1);

    protected abstract HashesIterator values(long var1);

    public int collect(long bucketOrd, long hash) {
        int k = AbstractLinearCounting.encodeHash(hash, this.p);
        return this.addEncoded(bucketOrd, k);
    }

    @Override
    public long cardinality(long bucketOrd) {
        long m = 0x2000000L;
        long v = 0x2000000L - (long)this.size(bucketOrd);
        return AbstractLinearCounting.linearCounting(0x2000000L, v);
    }

    static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    static int encodeHash(long hash, int p) {
        long encoded;
        long e = hash >>> 39;
        if ((e & AbstractLinearCounting.mask(25 - p)) == 0L) {
            int runLen = 1 + Math.min(Long.numberOfLeadingZeros(hash << 25), 39);
            encoded = e << 7 | (long)(runLen << 1) | 1L;
        } else {
            encoded = e << 1;
        }
        assert (PackedInts.bitsRequired((long)encoded) <= 32);
        assert (encoded != 0L);
        return (int)encoded;
    }

    public static interface HashesIterator {
        public int size();

        public boolean next();

        public int value();
    }
}

