/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.easysearch.common.Nullable;
import org.easysearch.common.ParseField;
import org.easysearch.common.TriFunction;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.metrics.PercentilesConfig;
import org.easysearch.search.aggregations.metrics.PercentilesMethod;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public abstract class AbstractPercentilesAggregationBuilder<T extends AbstractPercentilesAggregationBuilder<T>>
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource, T> {
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    protected boolean keyed = true;
    protected double[] values;
    private PercentilesConfig percentilesConfig;
    private ParseField valuesField;

    public static <T extends AbstractPercentilesAggregationBuilder<T>> ConstructingObjectParser<T, String> createParser(String aggName, TriFunction<String, double[], PercentilesConfig, T> ctor, Supplier<PercentilesConfig> defaultConfig, ParseField valuesField) {
        ConstructingObjectParser<AbstractPercentilesAggregationBuilder, String> parser = new ConstructingObjectParser<AbstractPercentilesAggregationBuilder, String>(aggName, false, (args, name) -> {
            double[] values;
            if (args == null || ((Object[])args).length == 0) {
                return (AbstractPercentilesAggregationBuilder)ctor.apply((String)name, (double[])null, (PercentilesConfig)defaultConfig.get());
            }
            PercentilesConfig tDigestConfig = (PercentilesConfig)args[1];
            PercentilesConfig hdrConfig = (PercentilesConfig)args[2];
            double[] dArray = values = args[0] != null ? ((List)args[0]).stream().mapToDouble(Double::doubleValue).toArray() : null;
            if (tDigestConfig != null && hdrConfig != null) {
                throw new IllegalArgumentException("Only one percentiles method should be declared.");
            }
            PercentilesConfig percentilesConfig = tDigestConfig == null && hdrConfig == null ? (PercentilesConfig)defaultConfig.get() : (tDigestConfig != null ? tDigestConfig : hdrConfig);
            return (AbstractPercentilesAggregationBuilder)ctor.apply((String)name, values, percentilesConfig);
        });
        ValuesSourceAggregationBuilder.declareFields(parser, true, true, false);
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), valuesField);
        parser.declareBoolean(AbstractPercentilesAggregationBuilder::keyed, KEYED_FIELD);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), PercentilesMethod.TDIGEST_PARSER, PercentilesMethod.TDIGEST.getParseField());
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), PercentilesMethod.HDR_PARSER, PercentilesMethod.HDR.getParseField());
        return parser;
    }

    AbstractPercentilesAggregationBuilder(String name, double[] values, PercentilesConfig percentilesConfig, ParseField valuesField) {
        super(name);
        if (values == null) {
            throw new IllegalArgumentException("[" + valuesField.getPreferredName() + "] must not be null: [" + name + "]");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("[" + valuesField.getPreferredName() + "] must not be an empty array: [" + name + "]");
        }
        double[] sortedValues = Arrays.copyOf(values, values.length);
        Arrays.sort(sortedValues);
        this.values = sortedValues;
        this.percentilesConfig = percentilesConfig;
        this.valuesField = valuesField;
    }

    AbstractPercentilesAggregationBuilder(AbstractPercentilesAggregationBuilder<T> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.percentilesConfig = clone.percentilesConfig;
        this.keyed = clone.keyed;
        this.values = clone.values;
        this.valuesField = clone.valuesField;
    }

    AbstractPercentilesAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.values = in.readDoubleArray();
        this.keyed = in.readBoolean();
        this.percentilesConfig = (PercentilesConfig)in.readOptionalWriteable(PercentilesConfig::fromStream);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.values);
        out.writeBoolean(this.keyed);
        out.writeOptionalWriteable(this.percentilesConfig);
    }

    public T keyed(boolean keyed) {
        this.keyed = keyed;
        return (T)this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Deprecated
    public T numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        if (this.percentilesConfig != null && !this.percentilesConfig.getMethod().equals(PercentilesMethod.HDR)) {
            throw new IllegalArgumentException("Cannot set [numberOfSignificantValueDigits] because the method has already been configured for TDigest");
        }
        this.percentilesConfig = new PercentilesConfig.Hdr(numberOfSignificantValueDigits);
        return (T)this;
    }

    @Deprecated
    public int numberOfSignificantValueDigits() {
        if (this.percentilesConfig != null && this.percentilesConfig.getMethod().equals(PercentilesMethod.HDR)) {
            return ((PercentilesConfig.Hdr)this.percentilesConfig).getNumberOfSignificantValueDigits();
        }
        throw new IllegalStateException("Percentiles [method] has not been configured yet, or is a TDigest");
    }

    @Deprecated
    public T compression(double compression) {
        if (this.percentilesConfig != null && !this.percentilesConfig.getMethod().equals(PercentilesMethod.TDIGEST)) {
            throw new IllegalArgumentException("Cannot set [compression] because the method has already been configured for HDRHistogram");
        }
        this.percentilesConfig = new PercentilesConfig.TDigest(compression);
        return (T)this;
    }

    @Deprecated
    public double compression() {
        if (this.percentilesConfig != null && this.percentilesConfig.getMethod().equals(PercentilesMethod.TDIGEST)) {
            return ((PercentilesConfig.TDigest)this.percentilesConfig).getCompression();
        }
        throw new IllegalStateException("Percentiles [method] has not been configured yet, or is a HdrHistogram");
    }

    @Deprecated
    public T method(PercentilesMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("[method] must not be null: [" + this.name + "]");
        }
        if (this.percentilesConfig == null) {
            this.percentilesConfig = method.equals(PercentilesMethod.TDIGEST) ? new PercentilesConfig.TDigest() : new PercentilesConfig.Hdr();
        } else if (!this.percentilesConfig.getMethod().equals(method)) {
            this.percentilesConfig = method.equals(PercentilesMethod.TDIGEST) ? new PercentilesConfig.TDigest() : new PercentilesConfig.Hdr();
        }
        return (T)this;
    }

    @Nullable
    @Deprecated
    public PercentilesMethod method() {
        return this.percentilesConfig == null ? null : this.percentilesConfig.getMethod();
    }

    @Nullable
    public PercentilesConfig percentilesConfig() {
        return this.percentilesConfig;
    }

    public T percentilesConfig(PercentilesConfig percentilesConfig) {
        this.percentilesConfig = percentilesConfig;
        return (T)this;
    }

    PercentilesConfig configOrDefault() {
        if (this.percentilesConfig == null) {
            return new PercentilesConfig.TDigest();
        }
        return this.percentilesConfig;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(this.valuesField.getPreferredName(), this.values);
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        builder = this.configOrDefault().toXContent(builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractPercentilesAggregationBuilder other = (AbstractPercentilesAggregationBuilder)obj;
        return Objects.deepEquals(this.values, other.values) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.configOrDefault(), other.configOrDefault());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.values), this.keyed, this.configOrDefault());
    }
}

