/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.metrics.AbstractInternalHDRPercentiles;
import org.easysearch.search.aggregations.metrics.Percentile;
import org.easysearch.search.aggregations.metrics.PercentileRanks;

public class InternalHDRPercentileRanks
extends AbstractInternalHDRPercentiles
implements PercentileRanks {
    public static final String NAME = "hdr_percentile_ranks";

    public InternalHDRPercentileRanks(String name, double[] cdfValues, DoubleHistogram state, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, cdfValues, state, keyed, formatter, metadata);
    }

    public InternalHDRPercentileRanks(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalHDRPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public String percentAsString(double value) {
        return this.valueAsString(String.valueOf(value));
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalHDRPercentiles createReduced(String name, double[] keys, DoubleHistogram merged, boolean keyed, Map<String, Object> metadata) {
        return new InternalHDRPercentileRanks(name, keys, merged, keyed, this.format, metadata);
    }

    public static double percentileRank(DoubleHistogram state, double value) {
        if (state.getTotalCount() == 0L) {
            return Double.NaN;
        }
        double percentileRank = state.getPercentileAtOrBelowValue(value);
        if (percentileRank < 0.0) {
            percentileRank = 0.0;
        } else if (percentileRank > 100.0) {
            percentileRank = 100.0;
        }
        return percentileRank;
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] values;
        private final DoubleHistogram state;
        private int i;

        public Iter(double[] values, DoubleHistogram state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            Percentile next = new Percentile(InternalHDRPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

