/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.pipeline;

import java.util.Arrays;

public class MovingFunctions {
    public static double max(double[] values) {
        return Arrays.stream(values).max().orElse(Double.NaN);
    }

    public static double min(double[] values) {
        return Arrays.stream(values).min().orElse(Double.NaN);
    }

    public static double sum(double[] values) {
        if (values.length == 0) {
            return 0.0;
        }
        return Arrays.stream(values).map(value -> {
            if (!Double.isNaN(value)) {
                return value;
            }
            return 0.0;
        }).sum();
    }

    public static double unweightedAvg(double[] values) {
        double avg = 0.0;
        long count = 0L;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            avg += v;
            ++count;
        }
        return count == 0L ? Double.NaN : avg / (double)count;
    }

    public static double stdDev(double[] values, double avg) {
        if (Double.isNaN(avg)) {
            return Double.NaN;
        }
        long count = 0L;
        double squaredMean = 0.0;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            squaredMean += Math.pow(v - avg, 2.0);
            ++count;
        }
        return Math.sqrt(squaredMean / (double)count);
    }

    public static double linearWeightedAvg(double[] values) {
        double avg = 0.0;
        long totalWeight = 1L;
        long current = 1L;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            avg += v * (double)current;
            totalWeight += current;
            ++current;
        }
        return totalWeight == 1L ? Double.NaN : avg / (double)totalWeight;
    }

    public static double ewma(double[] values, double alpha) {
        double avg = Double.NaN;
        boolean first = true;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            if (first) {
                avg = v;
                first = false;
                continue;
            }
            avg = v * alpha + avg * (1.0 - alpha);
        }
        return avg;
    }

    public static double holt(double[] values, double alpha, double beta) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return MovingFunctions.holtForecast(values, alpha, beta, 1)[0];
    }

    public static double[] holtForecast(double[] values, double alpha, double beta, int numForecasts) {
        double s = 0.0;
        double last_s = 0.0;
        double b = 0.0;
        double last_b = 0.0;
        int counter = 0;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            Double last = v;
            if (counter == 0) {
                s = v;
                b = v - last;
            } else {
                s = alpha * v + (1.0 - alpha) * (last_s + last_b);
                b = beta * (s - last_s) + (1.0 - beta) * last_b;
            }
            ++counter;
            last_s = s;
            last_b = b;
        }
        if (counter == 0) {
            return MovingFunctions.emptyPredictions(numForecasts);
        }
        double[] forecastValues = new double[numForecasts];
        for (int i = 0; i < numForecasts; ++i) {
            forecastValues[i] = s + (double)i * b;
        }
        return forecastValues;
    }

    public static double holtWinters(double[] values, double alpha, double beta, double gamma, int period, boolean multiplicative) {
        if (values.length == 0) {
            return Double.NaN;
        }
        double padding = multiplicative ? 1.0E-10 : 0.0;
        return MovingFunctions.holtWintersForecast(values, alpha, beta, gamma, period, padding, multiplicative, 1)[0];
    }

    public static double[] holtWintersForecast(double[] values, double alpha, double beta, double gamma, int period, double padding, boolean multiplicative, int numForecasts) {
        int i;
        if (values.length < period * 2) {
            throw new IllegalArgumentException("Holt-Winters aggregation requires at least (2 * period == 2 * " + period + " == " + 2 * period + ") data-points to function.  Only [" + values.length + "] were provided.");
        }
        double s = 0.0;
        double b = 0.0;
        double last_b = 0.0;
        double[] seasonal = new double[values.length];
        int counter = 0;
        double[] vs = new double[values.length];
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            vs[counter] = v + padding;
            ++counter;
        }
        if (counter == 0) {
            return MovingFunctions.emptyPredictions(numForecasts);
        }
        for (i = 0; i < period; ++i) {
            s += vs[i];
            b += (vs[i + period] - vs[i]) / (double)period;
        }
        b /= (double)period;
        double last_s = s /= (double)period;
        if (Double.compare(s, 0.0) == 0 || Double.compare(s, -0.0) == 0) {
            Arrays.fill(seasonal, 0.0);
        } else {
            for (i = 0; i < period; ++i) {
                seasonal[i] = vs[i] / s;
            }
        }
        for (i = period; i < vs.length; ++i) {
            s = multiplicative ? alpha * (vs[i] / seasonal[i - period]) + (1.0 - alpha) * (last_s + last_b) : alpha * (vs[i] - seasonal[i - period]) + (1.0 - alpha) * (last_s + last_b);
            b = beta * (s - last_s) + (1.0 - beta) * last_b;
            seasonal[i] = multiplicative ? gamma * (vs[i] / (last_s + last_b)) + (1.0 - gamma) * seasonal[i - period] : gamma * (vs[i] - (last_s - last_b)) + (1.0 - gamma) * seasonal[i - period];
            last_s = s;
            last_b = b;
        }
        double[] forecastValues = new double[numForecasts];
        for (int i2 = 1; i2 <= numForecasts; ++i2) {
            int idx = values.length - period + (i2 - 1) % period;
            forecastValues[i2 - 1] = multiplicative ? (s + (double)i2 * b) * seasonal[idx] : s + (double)i2 * b + seasonal[idx];
        }
        return forecastValues;
    }

    private static double[] emptyPredictions(int numPredictions) {
        double[] predictions = new double[numPredictions];
        Arrays.fill(predictions, Double.NaN);
        return predictions;
    }
}

