/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.easysearch.common.ParseField;
import org.easysearch.common.ParsingException;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.query.AbstractQueryBuilder;
import org.easysearch.index.query.QueryBuilder;
import org.easysearch.index.query.Rewriteable;
import org.easysearch.search.fetch.subphase.highlight.HighlightBuilder;

public abstract class AbstractHighlighterBuilder<HB extends AbstractHighlighterBuilder<?>>
implements Writeable,
Rewriteable<HB>,
ToXContentObject {
    public static final ParseField PRE_TAGS_FIELD = new ParseField("pre_tags", new String[0]);
    public static final ParseField POST_TAGS_FIELD = new ParseField("post_tags", new String[0]);
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    public static final ParseField HIGHLIGHT_FILTER_FIELD = new ParseField("highlight_filter", new String[0]);
    public static final ParseField FRAGMENT_SIZE_FIELD = new ParseField("fragment_size", new String[0]);
    public static final ParseField FRAGMENT_OFFSET_FIELD = new ParseField("fragment_offset", new String[0]);
    public static final ParseField NUMBER_OF_FRAGMENTS_FIELD = new ParseField("number_of_fragments", new String[0]);
    public static final ParseField ENCODER_FIELD = new ParseField("encoder", new String[0]);
    public static final ParseField REQUIRE_FIELD_MATCH_FIELD = new ParseField("require_field_match", new String[0]);
    public static final ParseField BOUNDARY_SCANNER_FIELD = new ParseField("boundary_scanner", new String[0]);
    public static final ParseField BOUNDARY_MAX_SCAN_FIELD = new ParseField("boundary_max_scan", new String[0]);
    public static final ParseField BOUNDARY_CHARS_FIELD = new ParseField("boundary_chars", new String[0]);
    public static final ParseField BOUNDARY_SCANNER_LOCALE_FIELD = new ParseField("boundary_scanner_locale", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField FRAGMENTER_FIELD = new ParseField("fragmenter", new String[0]);
    public static final ParseField NO_MATCH_SIZE_FIELD = new ParseField("no_match_size", new String[0]);
    public static final ParseField FORCE_SOURCE_FIELD = new ParseField("force_source", new String[0]);
    public static final ParseField PHRASE_LIMIT_FIELD = new ParseField("phrase_limit", new String[0]);
    public static final ParseField OPTIONS_FIELD = new ParseField("options", new String[0]);
    public static final ParseField HIGHLIGHT_QUERY_FIELD = new ParseField("highlight_query", new String[0]);
    public static final ParseField MATCHED_FIELDS_FIELD = new ParseField("matched_fields", new String[0]);
    protected String[] preTags;
    protected String[] postTags;
    protected Integer fragmentSize;
    protected Integer numOfFragments;
    protected String highlighterType;
    protected String fragmenter;
    protected QueryBuilder highlightQuery;
    protected HighlightBuilder.Order order;
    protected Boolean highlightFilter;
    protected Boolean forceSource;
    protected HighlightBuilder.BoundaryScannerType boundaryScannerType;
    protected Integer boundaryMaxScan;
    protected char[] boundaryChars;
    protected Locale boundaryScannerLocale;
    protected Integer noMatchSize;
    protected Integer phraseLimit;
    protected Map<String, Object> options;
    protected Boolean requireFieldMatch;

    public AbstractHighlighterBuilder() {
    }

    protected AbstractHighlighterBuilder(AbstractHighlighterBuilder<?> template, QueryBuilder queryBuilder) {
        this.preTags = template.preTags;
        this.postTags = template.postTags;
        this.fragmentSize = template.fragmentSize;
        this.numOfFragments = template.numOfFragments;
        this.highlighterType = template.highlighterType;
        this.fragmenter = template.fragmenter;
        this.highlightQuery = queryBuilder;
        this.order = template.order;
        this.highlightFilter = template.highlightFilter;
        this.forceSource = template.forceSource;
        this.boundaryScannerType = template.boundaryScannerType;
        this.boundaryMaxScan = template.boundaryMaxScan;
        this.boundaryChars = template.boundaryChars;
        this.boundaryScannerLocale = template.boundaryScannerLocale;
        this.noMatchSize = template.noMatchSize;
        this.phraseLimit = template.phraseLimit;
        this.options = template.options;
        this.requireFieldMatch = template.requireFieldMatch;
    }

    protected AbstractHighlighterBuilder(StreamInput in) throws IOException {
        this.preTags(in.readOptionalStringArray());
        this.postTags(in.readOptionalStringArray());
        this.fragmentSize(in.readOptionalVInt());
        this.numOfFragments(in.readOptionalVInt());
        this.highlighterType(in.readOptionalString());
        this.fragmenter(in.readOptionalString());
        if (in.readBoolean()) {
            this.highlightQuery(in.readNamedWriteable(QueryBuilder.class));
        }
        this.order(in.readOptionalWriteable(HighlightBuilder.Order::readFromStream));
        this.highlightFilter(in.readOptionalBoolean());
        this.forceSource(in.readOptionalBoolean());
        this.boundaryScannerType(in.readOptionalWriteable(HighlightBuilder.BoundaryScannerType::readFromStream));
        this.boundaryMaxScan(in.readOptionalVInt());
        if (in.readBoolean()) {
            this.boundaryChars(in.readString().toCharArray());
        }
        if (in.readBoolean()) {
            this.boundaryScannerLocale(in.readString());
        }
        this.noMatchSize(in.readOptionalVInt());
        this.phraseLimit(in.readOptionalVInt());
        if (in.readBoolean()) {
            this.options(in.readMap());
        }
        this.requireFieldMatch(in.readOptionalBoolean());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.preTags);
        out.writeOptionalStringArray(this.postTags);
        out.writeOptionalVInt(this.fragmentSize);
        out.writeOptionalVInt(this.numOfFragments);
        out.writeOptionalString(this.highlighterType);
        out.writeOptionalString(this.fragmenter);
        boolean hasQuery = this.highlightQuery != null;
        out.writeBoolean(hasQuery);
        if (hasQuery) {
            out.writeNamedWriteable(this.highlightQuery);
        }
        out.writeOptionalWriteable(this.order);
        out.writeOptionalBoolean(this.highlightFilter);
        out.writeOptionalBoolean(this.forceSource);
        out.writeOptionalWriteable(this.boundaryScannerType);
        out.writeOptionalVInt(this.boundaryMaxScan);
        boolean hasBounaryChars = this.boundaryChars != null;
        out.writeBoolean(hasBounaryChars);
        if (hasBounaryChars) {
            out.writeString(String.valueOf(this.boundaryChars));
        }
        boolean hasBoundaryScannerLocale = this.boundaryScannerLocale != null;
        out.writeBoolean(hasBoundaryScannerLocale);
        if (hasBoundaryScannerLocale) {
            out.writeString(this.boundaryScannerLocale.toLanguageTag());
        }
        out.writeOptionalVInt(this.noMatchSize);
        out.writeOptionalVInt(this.phraseLimit);
        boolean hasOptions = this.options != null;
        out.writeBoolean(hasOptions);
        if (hasOptions) {
            out.writeMap(this.options);
        }
        out.writeOptionalBoolean(this.requireFieldMatch);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public HB preTags(String ... preTags) {
        this.preTags = preTags;
        return (HB)this;
    }

    public String[] preTags() {
        return this.preTags;
    }

    public HB postTags(String ... postTags) {
        this.postTags = postTags;
        return (HB)this;
    }

    public String[] postTags() {
        return this.postTags;
    }

    public HB fragmentSize(Integer fragmentSize) {
        this.fragmentSize = fragmentSize;
        return (HB)this;
    }

    public Integer fragmentSize() {
        return this.fragmentSize;
    }

    public HB numOfFragments(Integer numOfFragments) {
        this.numOfFragments = numOfFragments;
        return (HB)this;
    }

    public Integer numOfFragments() {
        return this.numOfFragments;
    }

    public HB highlighterType(String highlighterType) {
        this.highlighterType = highlighterType;
        return (HB)this;
    }

    public String highlighterType() {
        return this.highlighterType;
    }

    public HB fragmenter(String fragmenter) {
        this.fragmenter = fragmenter;
        return (HB)this;
    }

    public String fragmenter() {
        return this.fragmenter;
    }

    public HB highlightQuery(QueryBuilder highlightQuery) {
        this.highlightQuery = highlightQuery;
        return (HB)this;
    }

    public QueryBuilder highlightQuery() {
        return this.highlightQuery;
    }

    public HB order(String order) {
        return this.order(HighlightBuilder.Order.fromString(order));
    }

    public HB order(HighlightBuilder.Order scoreOrdered) {
        this.order = scoreOrdered;
        return (HB)this;
    }

    public HighlightBuilder.Order order() {
        return this.order;
    }

    public HB highlightFilter(Boolean highlightFilter) {
        this.highlightFilter = highlightFilter;
        return (HB)this;
    }

    public Boolean highlightFilter() {
        return this.highlightFilter;
    }

    public HB boundaryScannerType(String boundaryScannerType) {
        this.boundaryScannerType = HighlightBuilder.BoundaryScannerType.fromString(boundaryScannerType);
        return (HB)this;
    }

    public HB boundaryScannerType(HighlightBuilder.BoundaryScannerType boundaryScannerType) {
        this.boundaryScannerType = boundaryScannerType;
        return (HB)this;
    }

    public HighlightBuilder.BoundaryScannerType boundaryScannerType() {
        return this.boundaryScannerType;
    }

    public HB boundaryMaxScan(Integer boundaryMaxScan) {
        this.boundaryMaxScan = boundaryMaxScan;
        return (HB)this;
    }

    public Integer boundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    public HB boundaryChars(char[] boundaryChars) {
        this.boundaryChars = boundaryChars;
        return (HB)this;
    }

    public char[] boundaryChars() {
        return this.boundaryChars;
    }

    public HB boundaryScannerLocale(String boundaryScannerLocale) {
        if (boundaryScannerLocale != null) {
            this.boundaryScannerLocale = Locale.forLanguageTag(boundaryScannerLocale);
        }
        return (HB)this;
    }

    public Locale boundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    public HB options(Map<String, Object> options) {
        this.options = options;
        return (HB)this;
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public HB requireFieldMatch(Boolean requireFieldMatch) {
        this.requireFieldMatch = requireFieldMatch;
        return (HB)this;
    }

    public Boolean requireFieldMatch() {
        return this.requireFieldMatch;
    }

    public HB noMatchSize(Integer noMatchSize) {
        this.noMatchSize = noMatchSize;
        return (HB)this;
    }

    public Integer noMatchSize() {
        return this.noMatchSize;
    }

    public HB phraseLimit(Integer phraseLimit) {
        this.phraseLimit = phraseLimit;
        return (HB)this;
    }

    public Integer phraseLimit() {
        return this.phraseLimit;
    }

    public HB forceSource(Boolean forceSource) {
        this.forceSource = forceSource;
        return (HB)this;
    }

    public Boolean forceSource() {
        return this.forceSource;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerXContent(builder);
        builder.endObject();
        return builder;
    }

    protected abstract void innerXContent(XContentBuilder var1) throws IOException;

    void commonOptionsToXContent(XContentBuilder builder) throws IOException {
        if (this.preTags != null) {
            builder.array(PRE_TAGS_FIELD.getPreferredName(), this.preTags);
        }
        if (this.postTags != null) {
            builder.array(POST_TAGS_FIELD.getPreferredName(), this.postTags);
        }
        if (this.fragmentSize != null) {
            builder.field(FRAGMENT_SIZE_FIELD.getPreferredName(), this.fragmentSize);
        }
        if (this.numOfFragments != null) {
            builder.field(NUMBER_OF_FRAGMENTS_FIELD.getPreferredName(), this.numOfFragments);
        }
        if (this.highlighterType != null) {
            builder.field(TYPE_FIELD.getPreferredName(), this.highlighterType);
        }
        if (this.fragmenter != null) {
            builder.field(FRAGMENTER_FIELD.getPreferredName(), this.fragmenter);
        }
        if (this.highlightQuery != null) {
            builder.field(HIGHLIGHT_QUERY_FIELD.getPreferredName(), this.highlightQuery);
        }
        if (this.order != null) {
            builder.field(ORDER_FIELD.getPreferredName(), this.order.toString());
        }
        if (this.highlightFilter != null) {
            builder.field(HIGHLIGHT_FILTER_FIELD.getPreferredName(), this.highlightFilter);
        }
        if (this.boundaryScannerType != null) {
            builder.field(BOUNDARY_SCANNER_FIELD.getPreferredName(), this.boundaryScannerType.name());
        }
        if (this.boundaryMaxScan != null) {
            builder.field(BOUNDARY_MAX_SCAN_FIELD.getPreferredName(), this.boundaryMaxScan);
        }
        if (this.boundaryChars != null) {
            builder.field(BOUNDARY_CHARS_FIELD.getPreferredName(), new String(this.boundaryChars));
        }
        if (this.boundaryScannerLocale != null) {
            builder.field(BOUNDARY_SCANNER_LOCALE_FIELD.getPreferredName(), this.boundaryScannerLocale.toLanguageTag());
        }
        if (this.options != null && this.options.size() > 0) {
            builder.field(OPTIONS_FIELD.getPreferredName(), this.options);
        }
        if (this.forceSource != null) {
            builder.field(FORCE_SOURCE_FIELD.getPreferredName(), this.forceSource);
        }
        if (this.requireFieldMatch != null) {
            builder.field(REQUIRE_FIELD_MATCH_FIELD.getPreferredName(), this.requireFieldMatch);
        }
        if (this.noMatchSize != null) {
            builder.field(NO_MATCH_SIZE_FIELD.getPreferredName(), this.noMatchSize);
        }
        if (this.phraseLimit != null) {
            builder.field(PHRASE_LIMIT_FIELD.getPreferredName(), this.phraseLimit);
        }
    }

    static <HB extends AbstractHighlighterBuilder<HB>> BiFunction<XContentParser, HB, HB> setupParser(ObjectParser<HB, Void> parser) {
        parser.declareStringArray(ObjectParser.fromList(String.class, AbstractHighlighterBuilder::preTags), PRE_TAGS_FIELD);
        parser.declareStringArray(ObjectParser.fromList(String.class, AbstractHighlighterBuilder::postTags), POST_TAGS_FIELD);
        parser.declareString(AbstractHighlighterBuilder::order, ORDER_FIELD);
        parser.declareBoolean(AbstractHighlighterBuilder::highlightFilter, HIGHLIGHT_FILTER_FIELD);
        parser.declareInt(AbstractHighlighterBuilder::fragmentSize, FRAGMENT_SIZE_FIELD);
        parser.declareInt(AbstractHighlighterBuilder::numOfFragments, NUMBER_OF_FRAGMENTS_FIELD);
        parser.declareBoolean(AbstractHighlighterBuilder::requireFieldMatch, REQUIRE_FIELD_MATCH_FIELD);
        parser.declareString(AbstractHighlighterBuilder::boundaryScannerType, BOUNDARY_SCANNER_FIELD);
        parser.declareInt(AbstractHighlighterBuilder::boundaryMaxScan, BOUNDARY_MAX_SCAN_FIELD);
        parser.declareString((hb, bc) -> hb.boundaryChars(bc.toCharArray()), BOUNDARY_CHARS_FIELD);
        parser.declareString(AbstractHighlighterBuilder::boundaryScannerLocale, BOUNDARY_SCANNER_LOCALE_FIELD);
        parser.declareString(AbstractHighlighterBuilder::highlighterType, TYPE_FIELD);
        parser.declareString(AbstractHighlighterBuilder::fragmenter, FRAGMENTER_FIELD);
        parser.declareInt(AbstractHighlighterBuilder::noMatchSize, NO_MATCH_SIZE_FIELD);
        parser.declareBoolean(AbstractHighlighterBuilder::forceSource, FORCE_SOURCE_FIELD);
        parser.declareInt(AbstractHighlighterBuilder::phraseLimit, PHRASE_LIMIT_FIELD);
        parser.declareObject(AbstractHighlighterBuilder::options, (p, c) -> {
            try {
                return p.map();
            }
            catch (IOException e) {
                throw new RuntimeException("Error parsing options", e);
            }
        }, OPTIONS_FIELD);
        parser.declareObject(AbstractHighlighterBuilder::highlightQuery, (p, c) -> {
            try {
                return AbstractQueryBuilder.parseInnerQueryBuilder(p);
            }
            catch (IOException e) {
                throw new RuntimeException("Error parsing query", e);
            }
        }, HIGHLIGHT_QUERY_FIELD);
        return (p, hb) -> {
            try {
                parser.parse((XContentParser)p, (Object)hb, (Void)null);
                if (hb.preTags() != null && hb.postTags() == null) {
                    throw new ParsingException(p.getTokenLocation(), "pre_tags are set but post_tags are not set", new Object[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return hb;
        };
    }

    public final int hashCode() {
        return Objects.hash(this.getClass(), Arrays.hashCode(this.preTags), Arrays.hashCode(this.postTags), this.fragmentSize, this.numOfFragments, this.highlighterType, this.fragmenter, this.highlightQuery, this.order, this.highlightFilter, this.forceSource, this.boundaryScannerType, this.boundaryMaxScan, Arrays.hashCode(this.boundaryChars), this.boundaryScannerLocale, this.noMatchSize, this.phraseLimit, this.options, this.requireFieldMatch, this.doHashCode());
    }

    protected abstract int doHashCode();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractHighlighterBuilder other = (AbstractHighlighterBuilder)obj;
        return Arrays.equals(this.preTags, other.preTags) && Arrays.equals(this.postTags, other.postTags) && Objects.equals(this.fragmentSize, other.fragmentSize) && Objects.equals(this.numOfFragments, other.numOfFragments) && Objects.equals(this.highlighterType, other.highlighterType) && Objects.equals(this.fragmenter, other.fragmenter) && Objects.equals(this.highlightQuery, other.highlightQuery) && Objects.equals(this.order, other.order) && Objects.equals(this.highlightFilter, other.highlightFilter) && Objects.equals(this.forceSource, other.forceSource) && Objects.equals(this.boundaryScannerType, other.boundaryScannerType) && Objects.equals(this.boundaryMaxScan, other.boundaryMaxScan) && Arrays.equals(this.boundaryChars, other.boundaryChars) && Objects.equals(this.boundaryScannerLocale, other.boundaryScannerLocale) && Objects.equals(this.noMatchSize, other.noMatchSize) && Objects.equals(this.phraseLimit, other.phraseLimit) && Objects.equals(this.options, other.options) && Objects.equals(this.requireFieldMatch, other.requireFieldMatch) && this.doEquals(other);
    }

    protected abstract boolean doEquals(HB var1);

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

