/*
 * Decompiled with CFR 0.152.
 */
package com.infisical.sdk.api;

import com.google.gson.Gson;
import com.infisical.sdk.util.InfisicalException;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.Map;

public class ApiClient {
    private final OkHttpClient client = new OkHttpClient();
    private String accessToken;
    private String baseUrl;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public ApiClient(String baseUrl, String accessToken) {
        this.baseUrl = baseUrl;
        if (accessToken != null) {
            this.accessToken = accessToken;
        }
        this.formatBaseUrl();
    }

    private void formatBaseUrl() {
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (!this.baseUrl.matches("^[a-zA-Z]+://.*")) {
            this.baseUrl = "http://" + this.baseUrl;
        }
        if (this.baseUrl.endsWith("/api")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 4);
        }
    }

    public String GetBaseUrl() {
        return this.baseUrl;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    private String formatErrorMessage(Response response) throws IOException {
        Object message = String.format("Unexpected response: %s", response);
        try (ResponseBody errorBody = response.body();){
            String bodyString;
            if (errorBody != null && !(bodyString = errorBody.string()).isEmpty()) {
                message = (String)message + String.format(" - %s", bodyString);
            }
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, R> R post(String url, T requestBody, Class<R> responseType) throws InfisicalException {
        try {
            Gson gson = new Gson();
            String jsonBody = gson.toJson(requestBody);
            Request.Builder requestBuilder = new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)jsonBody)).header("Accept", "application/json");
            if (this.accessToken != null && !this.accessToken.isEmpty()) {
                requestBuilder.addHeader("Authorization", "Bearer " + this.accessToken);
            }
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    throw new IOException(this.formatErrorMessage(response));
                }
                if (responseBody == null) {
                    throw new IOException("Response body is null");
                }
                String responseJson = responseBody.string();
                Object object = gson.fromJson(responseJson, responseType);
                return (R)object;
            }
        }
        catch (IOException e) {
            throw new InfisicalException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R get(String baseUrl, Map<String, String> queryParams, Class<R> responseType) throws InfisicalException {
        try {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)baseUrl).newBuilder();
            queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
            Request.Builder requestBuilder = new Request.Builder().url(urlBuilder.build()).get().header("Accept", "application/json");
            if (this.accessToken != null && !this.accessToken.isEmpty()) {
                requestBuilder.addHeader("Authorization", "Bearer " + this.accessToken);
            }
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    throw new IOException(this.formatErrorMessage(response));
                }
                if (responseBody == null) {
                    throw new IOException("Response body is null");
                }
                Gson gson = new Gson();
                String responseJson = responseBody.string();
                Object object = gson.fromJson(responseJson, responseType);
                return (R)object;
            }
        }
        catch (IOException e) {
            throw new InfisicalException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, R> R patch(String url, T requestBody, Class<R> responseType) throws InfisicalException {
        try {
            Gson gson = new Gson();
            String jsonBody = gson.toJson(requestBody);
            Request.Builder requestBuilder = new Request.Builder().url(url).patch(RequestBody.create((MediaType)JSON, (String)jsonBody)).header("Accept", "application/json");
            if (this.accessToken != null && !this.accessToken.isEmpty()) {
                requestBuilder.addHeader("Authorization", "Bearer " + this.accessToken);
            }
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    throw new IOException(this.formatErrorMessage(response));
                }
                if (responseBody == null) {
                    throw new IOException("Response body is null");
                }
                String responseJson = responseBody.string();
                Object object = gson.fromJson(responseJson, responseType);
                return (R)object;
            }
        }
        catch (IOException e) {
            throw new InfisicalException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, R> R delete(String url, T requestBody, Class<R> responseType) throws InfisicalException {
        try {
            Gson gson = new Gson();
            String jsonBody = gson.toJson(requestBody);
            Request.Builder requestBuilder = new Request.Builder().url(url).delete(RequestBody.create((MediaType)JSON, (String)jsonBody)).header("Accept", "application/json");
            if (this.accessToken != null && !this.accessToken.isEmpty()) {
                requestBuilder.addHeader("Authorization", "Bearer " + this.accessToken);
            }
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody responseBody = response.body();){
                if (!response.isSuccessful()) {
                    throw new IOException(this.formatErrorMessage(response));
                }
                if (responseBody == null) {
                    throw new IOException("Response body is null");
                }
                String responseJson = responseBody.string();
                Object object = gson.fromJson(responseJson, responseType);
                return (R)object;
            }
        }
        catch (IOException e) {
            throw new InfisicalException(e);
        }
    }
}

