/*
 * Decompiled with CFR 0.152.
 */
package com.infisical.sdk.resources;

import com.infisical.sdk.api.ApiClient;
import com.infisical.sdk.models.MachineIdentityCredential;
import com.infisical.sdk.models.UniversalAuthLoginInput;
import com.infisical.sdk.util.InfisicalException;
import java.util.function.Consumer;

public class AuthClient {
    private final ApiClient apiClient;
    private final Consumer<String> onAuthenticate;

    public AuthClient(ApiClient apiClient, Consumer<String> onAuthenticate) {
        this.apiClient = apiClient;
        this.onAuthenticate = onAuthenticate;
    }

    public void UniversalAuthLogin(String clientId, String clientSecret) throws InfisicalException {
        UniversalAuthLoginInput params = UniversalAuthLoginInput.builder().clientId(clientId).clientSecret(clientSecret).build();
        String url = String.format("%s%s", this.apiClient.GetBaseUrl(), "/api/v1/auth/universal-auth/login");
        MachineIdentityCredential credential = this.apiClient.post(url, params, MachineIdentityCredential.class);
        this.onAuthenticate.accept(credential.getAccessToken());
    }

    public void SetAccessToken(String accessToken) {
        this.onAuthenticate.accept(accessToken);
    }
}

