/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions.restriction;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.functions.properties.FunctionsParameters;
import com.influxdb.query.dsl.functions.restriction.Restrictions;
import javax.annotation.Nonnull;

public final class ColumnRestriction {
    private final String fieldName;

    ColumnRestriction(@Nonnull String recordColumn) {
        Arguments.checkNonEmpty((String)recordColumn, (String)"Record column");
        this.fieldName = recordColumn;
    }

    @Nonnull
    public Restrictions equal(@Nonnull Object value) {
        return this.custom(value, "==");
    }

    @Nonnull
    public Restrictions notEqual(@Nonnull Object value) {
        return this.custom(value, "!=");
    }

    @Nonnull
    public Restrictions less(@Nonnull Object value) {
        return this.custom(value, "<");
    }

    @Nonnull
    public Restrictions greater(@Nonnull Object value) {
        return this.custom(value, ">");
    }

    @Nonnull
    public Restrictions lessOrEqual(@Nonnull Object value) {
        return this.custom(value, "<=");
    }

    @Nonnull
    public Restrictions greaterOrEqual(@Nonnull Object value) {
        return this.custom(value, ">=");
    }

    @Nonnull
    public Restrictions custom(@Nonnull Object value, @Nonnull String operator) {
        return new OperatorRestrictions(this.fieldName, value, operator);
    }

    @Nonnull
    public Restrictions exists() {
        return new ExistsRestrictions(this.fieldName);
    }

    private final class OperatorRestrictions
    extends Restrictions {
        private final String fieldName;
        private final Object fieldValue;
        private final String operator;

        private OperatorRestrictions(@Nonnull String fieldName, @Nonnull Object fieldValue, String operator) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
            this.operator = operator;
        }

        public String toString() {
            String value = this.fieldValue instanceof String ? "\"" + this.fieldValue + "\"" : FunctionsParameters.serializeValue(this.fieldValue);
            return "r[\"" + this.fieldName + "\"] " + this.operator + " " + value;
        }
    }

    private final class ExistsRestrictions
    extends Restrictions {
        private final String fieldName;

        public ExistsRestrictions(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return "exists r[\"" + this.fieldName + "\"]";
        }
    }
}

