/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

public final class JoinFlux
extends AbstractParametrizedFlux {
    private Map<String, Flux> tables = new LinkedHashMap<String, Flux>();

    public JoinFlux() {
        this.withPropertyValue("tables", () -> {
            StringJoiner tablesValue = new StringJoiner(", ", "{", "}");
            this.tables.keySet().forEach(key -> tablesValue.add(String.format("%s:%s", key, key)));
            return tablesValue.toString();
        });
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "join";
    }

    @Override
    protected void beforeAppendOperatorName(@Nonnull StringBuilder operator, @Nonnull Map<String, Object> parameters) {
        this.tables.keySet().forEach(key -> operator.append(String.format("%s = %s\n", key, this.tables.get(key).toString(parameters))));
    }

    @Nonnull
    public JoinFlux withTable(@Nonnull String name, @Nonnull Flux table) {
        Arguments.checkNonEmpty((String)name, (String)"FluxTable name");
        Arguments.checkNotNull((Object)table, (String)"Flux script to map table");
        this.tables.put(name, table);
        return this;
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull String tag) {
        Arguments.checkNonEmpty((String)tag, (String)"Tag name");
        return this.withOn(new String[]{tag});
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull String[] tags) {
        Arguments.checkNotNull((Object)tags, (String)"Tags are required");
        this.withPropertyValue("on", tags);
        return this;
    }

    @Nonnull
    public JoinFlux withOn(@Nonnull Collection<String> tags) {
        Arguments.checkNotNull(tags, (String)"Tags are required");
        this.withPropertyValue("on", tags);
        return this;
    }

    @Nonnull
    public JoinFlux withMethod(@Nonnull String method) {
        Arguments.checkNonEmpty((String)method, (String)"Method");
        this.withPropertyValueEscaped("method", method);
        return this;
    }

    @Nonnull
    public JoinFlux withMethod(@Nonnull MethodType method) {
        Arguments.checkNotNull((Object)((Object)method), (String)"Method");
        this.withPropertyValueEscaped("method", method.toString().toLowerCase());
        return this;
    }

    public static enum MethodType {
        INNER,
        CROSS,
        LEFT,
        RIGHT,
        OUTER;

    }
}

