/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions.restriction;

import com.influxdb.query.dsl.functions.restriction.ColumnRestriction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Restrictions {
    Restrictions() {
    }

    @Nonnull
    public static Restrictions and(Restrictions ... restrictions) {
        return new Logical("and", restrictions);
    }

    @Nonnull
    public static Restrictions or(Restrictions ... restrictions) {
        return new Logical("or", restrictions);
    }

    @Nonnull
    public static ColumnRestriction measurement() {
        return new ColumnRestriction("_measurement");
    }

    @Nonnull
    public static ColumnRestriction field() {
        return new ColumnRestriction("_field");
    }

    @Nonnull
    public static ColumnRestriction start() {
        return new ColumnRestriction("_start");
    }

    @Nonnull
    public static ColumnRestriction stop() {
        return new ColumnRestriction("_stop");
    }

    @Nonnull
    public static ColumnRestriction time() {
        return new ColumnRestriction("_time");
    }

    @Nonnull
    public static ColumnRestriction value() {
        return new ColumnRestriction("_value");
    }

    @Nonnull
    public static ColumnRestriction tag(@Nonnull String tagName) {
        return Restrictions.column(tagName);
    }

    @Nonnull
    public static ColumnRestriction column(@Nonnull String columnName) {
        return new ColumnRestriction(columnName);
    }

    private static class Logical
    extends Restrictions {
        private final String operator;
        private final Restrictions[] restrictions;

        Logical(@Nonnull String operator, Restrictions ... restrictions) {
            this.operator = operator;
            this.restrictions = restrictions;
        }

        public String toString() {
            return Stream.of(this.restrictions).map(Object::toString).collect(Collectors.joining(" " + this.operator + " ", "(", ")"));
        }
    }
}

