/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public final class WindowFlux
extends AbstractParametrizedFlux {
    public WindowFlux(@Nonnull Flux flux) {
        super(flux);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "window";
    }

    @Nonnull
    public WindowFlux withEvery(@Nonnull Long every, @Nonnull ChronoUnit everyUnit) {
        Arguments.checkNotNull((Object)every, (String)"Every is required");
        Arguments.checkNotNull((Object)everyUnit, (String)"Every ChronoUnit is required");
        this.withPropertyValue("every", every, everyUnit);
        return this;
    }

    @Nonnull
    public WindowFlux withEvery(@Nonnull String every) {
        Arguments.checkDuration((String)every, (String)"Every");
        this.withPropertyValue("every", every);
        return this;
    }

    @Nonnull
    public WindowFlux withPeriod(@Nonnull Long period, @Nonnull ChronoUnit periodUnit) {
        Arguments.checkNotNull((Object)period, (String)"Period is required");
        Arguments.checkNotNull((Object)periodUnit, (String)"Period ChronoUnit is required");
        this.withPropertyValue("period", period, periodUnit);
        return this;
    }

    @Nonnull
    public WindowFlux withPeriod(@Nonnull String period) {
        Arguments.checkDuration((String)period, (String)"Period");
        this.withPropertyValue("period", period);
        return this;
    }

    @Nonnull
    public WindowFlux withOffset(@Nonnull Long offset, @Nonnull ChronoUnit offsetUnit) {
        Arguments.checkNotNull((Object)offset, (String)"Offset is required");
        Arguments.checkNotNull((Object)offsetUnit, (String)"Offset ChronoUnit is required");
        this.withPropertyValue("start", offset, offsetUnit);
        return this;
    }

    @Nonnull
    public WindowFlux withOffset(@Nonnull Instant start) {
        Arguments.checkNotNull((Object)start, (String)"Offset is required");
        this.withPropertyValue("offset", start);
        return this;
    }

    @Nonnull
    public WindowFlux withOffset(@Nonnull String offset) {
        Arguments.checkDuration((String)offset, (String)"offset");
        this.withPropertyValue("offset", offset);
        return this;
    }

    @Nonnull
    public WindowFlux withTimeColumn(@Nonnull String timeColumn) {
        Arguments.checkNonEmpty((String)timeColumn, (String)"Time column");
        this.withPropertyValueEscaped("timeColumn", timeColumn);
        return this;
    }

    @Nonnull
    public WindowFlux withStartColumn(@Nonnull String startColumn) {
        Arguments.checkNonEmpty((String)startColumn, (String)"Start column");
        this.withPropertyValueEscaped("startColumn", startColumn);
        return this;
    }

    @Nonnull
    public WindowFlux withStopCol(@Nonnull String stopColumn) {
        Arguments.checkNonEmpty((String)stopColumn, (String)"Strop column");
        this.withPropertyValueEscaped("stopColumn", stopColumn);
        return this;
    }
}

