/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class GroupFlux
extends AbstractParametrizedFlux {
    public GroupFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "group";
    }

    @Nonnull
    public GroupFlux withBy(@Nonnull String groupBy) {
        Arguments.checkNotNull((Object)groupBy, (String)"GroupBy Column are required");
        this.withPropertyValue("columns", new String[]{groupBy});
        return this;
    }

    @Nonnull
    public GroupFlux withBy(@Nonnull String[] groupBy) {
        Arguments.checkNotNull((Object)groupBy, (String)"GroupBy Columns are required");
        this.withPropertyValue("columns", groupBy);
        return this;
    }

    @Nonnull
    public GroupFlux withBy(@Nonnull Collection<String> groupBy) {
        Arguments.checkNotNull(groupBy, (String)"GroupBy Columns are required");
        this.withPropertyValue("columns", groupBy);
        return this;
    }

    @Nonnull
    public GroupFlux withExcept(@Nonnull String except) {
        Arguments.checkNotNull((Object)except, (String)"GroupBy Except Columns are required");
        this.withPropertyValue("columns", new String[]{except});
        this.withPropertyValueEscaped("mode", "except");
        return this;
    }

    @Nonnull
    public GroupFlux withExcept(@Nonnull String[] except) {
        Arguments.checkNotNull((Object)except, (String)"GroupBy Except Columns are required");
        this.withPropertyValue("columns", except);
        this.withPropertyValueEscaped("mode", "except");
        return this;
    }

    @Nonnull
    public GroupFlux withExcept(@Nonnull Collection<String> except) {
        Arguments.checkNotNull(except, (String)"GroupBy Except Columns are required");
        this.withPropertyValue("columns", except);
        this.withPropertyValueEscaped("mode", "except");
        return this;
    }
}

