/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class ShiftFlux
extends AbstractParametrizedFlux {
    public ShiftFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "shift";
    }

    @Nonnull
    public ShiftFlux withShift(@Nonnull Long amount, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)amount, (String)"Amount is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        this.withPropertyValue("shift", amount, unit);
        return this;
    }

    @Nonnull
    public ShiftFlux withShift(@Nonnull String amount) {
        Arguments.checkDuration((String)amount, (String)"Amount");
        this.withPropertyValue("shift", amount);
        return this;
    }

    @Nonnull
    public ShiftFlux withColumns(@Nonnull String[] columns) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public ShiftFlux withColumns(@Nonnull Collection<String> columns) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }
}

