/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class TimeShiftFlux
extends AbstractParametrizedFlux {
    public TimeShiftFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "timeShift";
    }

    @Nonnull
    public TimeShiftFlux withDuration(@Nonnull Long amount, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)amount, (String)"Amount is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        this.withPropertyValue("duration", amount, unit);
        return this;
    }

    @Nonnull
    public TimeShiftFlux withDuration(@Nonnull String amount) {
        Arguments.checkDuration((String)amount, (String)"Amount");
        this.withPropertyValue("duration", amount);
        return this;
    }

    @Nonnull
    public TimeShiftFlux withColumns(@Nonnull String[] columns) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public TimeShiftFlux withColumns(@Nonnull Collection<String> columns) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }
}

