/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public final class RangeFlux
extends AbstractParametrizedFlux {
    public RangeFlux(@Nonnull Flux flux) {
        super(flux);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "range";
    }

    @Nonnull
    public RangeFlux withStart(@Nonnull Instant start) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        this.withPropertyValue("start", start);
        return this;
    }

    @Nonnull
    public RangeFlux withStart(@Nonnull Long start, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        this.withPropertyValue("start", start, unit);
        return this;
    }

    @Nonnull
    public RangeFlux withStart(@Nonnull String start) {
        Arguments.checkDuration((String)start, (String)"Start");
        this.withPropertyValue("start", start);
        return this;
    }

    @Nonnull
    public RangeFlux withStop(@Nonnull Instant stop) {
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        this.withPropertyValue("stop", stop);
        return this;
    }

    @Nonnull
    public RangeFlux withStop(@Nonnull Long stop, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        this.withPropertyValue("stop", stop, unit);
        return this;
    }

    @Nonnull
    public RangeFlux withStop(@Nonnull String stop) {
        Arguments.checkDuration((String)stop, (String)"Stop");
        this.withPropertyValue("stop", stop);
        return this;
    }
}

