/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.utils.Arguments;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public final class AggregateWindow
extends AbstractParametrizedFlux {
    public AggregateWindow(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "aggregateWindow";
    }

    @Nonnull
    public AggregateWindow withEvery(@Nonnull Long every, @Nonnull ChronoUnit everyUnit) {
        Arguments.checkNotNull((Object)every, (String)"Every is required");
        Arguments.checkNotNull((Object)everyUnit, (String)"Every ChronoUnit is required");
        this.withPropertyValue("every", every, everyUnit);
        return this;
    }

    @Nonnull
    public AggregateWindow withEvery(@Nonnull String every) {
        Arguments.checkDuration((String)every, (String)"Every");
        this.withPropertyValue("every", every);
        return this;
    }

    @Nonnull
    public AggregateWindow withFunction(@Nonnull String function) {
        Arguments.checkNonEmpty((String)function, (String)"Function");
        this.withFunction("fn: (column, tables=<-)", function);
        return this;
    }

    @Nonnull
    public AggregateWindow withAggregateFunction(@Nonnull String namedFunction) {
        Arguments.checkNonEmpty((String)namedFunction, (String)"Function");
        this.withPropertyValue("fn", namedFunction);
        return this;
    }

    @Nonnull
    public AggregateWindow withColumn(@Nonnull String column) {
        Arguments.checkNonEmpty((String)column, (String)"Column");
        this.withPropertyValueEscaped("column", column);
        return this;
    }

    @Nonnull
    public AggregateWindow withTimeSrc(@Nonnull String timeSrc) {
        Arguments.checkNonEmpty((String)timeSrc, (String)"timeSrc");
        this.withPropertyValueEscaped("timeSrc", timeSrc);
        return this;
    }

    @Nonnull
    public AggregateWindow withTimeDst(@Nonnull String timeDst) {
        Arguments.checkNonEmpty((String)timeDst, (String)"timeDst");
        this.withPropertyValueEscaped("timeDst", timeDst);
        return this;
    }

    @Nonnull
    public AggregateWindow withCreateEmpty(boolean createEmpty) {
        this.withPropertyValue("createEmpty", createEmpty);
        return this;
    }
}

