/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl;

import com.influxdb.query.dsl.Expression;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.IsVariableAssignment;
import com.influxdb.query.dsl.utils.ImportUtils;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class VariableAssignment
extends Flux
implements IsVariableAssignment {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final Expression expression;

    public VariableAssignment(@Nonnull String name, @Nonnull Expression expression) {
        this.name = name;
        this.expression = expression;
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.name;
    }

    @Override
    public void appendActual(@Nonnull Map<String, Object> parameters, @Nonnull StringBuilder builder) {
        builder.append(this.name);
    }

    @Override
    public String toString(@Nonnull Map<String, Object> parameters, boolean prependImports) {
        StringBuilder builder = new StringBuilder();
        if (prependImports) {
            builder.append(ImportUtils.getImportsString(this));
        }
        builder.append(this.name).append(" = ").append(this.expression.toString(parameters, false));
        return builder.toString();
    }

    @Override
    public Set<String> getImports() {
        TreeSet<String> result = new TreeSet<String>(this.expression.getImports());
        if (this.imports != null) {
            result.addAll(this.imports);
        }
        return result;
    }
}

