/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions.properties;

import com.influxdb.query.dsl.VariableAssignment;
import com.influxdb.query.dsl.functions.properties.TimeInterval;
import com.influxdb.utils.Arguments;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FunctionsParameters {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.nnnnnnnnn'Z'").withZone(ZoneId.of("UTC"));
    private static final String DEFAULT_DELIMITER = ":";
    private static final String FUNCTION_DELIMITER = " => ";
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    private final Map<String, Property<?>> properties = new LinkedHashMap();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public static String escapeDoubleQuotes(String val) {
        return val.replace("\"", "\\\"");
    }

    private FunctionsParameters() {
    }

    @Nonnull
    public static FunctionsParameters of() {
        return new FunctionsParameters();
    }

    @Nullable
    public static String serializeValue(@Nonnull Object value, boolean escapeStrings) {
        if (value instanceof String) {
            if (escapeStrings) {
                return "\"" + FunctionsParameters.escapeDoubleQuotes((String)((Object)value)) + "\"";
            }
            return (String)((Object)value);
        }
        if (value instanceof Integer || value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Number) {
            String s = value.toString();
            if (s.contains("E")) {
                return DECIMAL_FORMAT.format(value);
            }
            return s;
        }
        List<Object> serializedValue = value;
        if (serializedValue.getClass().isArray()) {
            serializedValue = Arrays.asList((Object[])value);
        }
        if (serializedValue instanceof Collection) {
            Collection collection = serializedValue;
            if (collection.isEmpty()) {
                return null;
            }
            return collection.stream().map(v -> FunctionsParameters.serializeValue(v, true)).collect(Collectors.joining(", ", "[", "]"));
        }
        if (serializedValue instanceof Map) {
            return ((Map)((Object)serializedValue)).entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + ": " + FunctionsParameters.serializeValue(entry.getValue(), true)).collect(Collectors.joining(", ", "{", "}"));
        }
        if (serializedValue instanceof Instant) {
            return DATE_FORMATTER.format((Instant)((Object)value));
        }
        if (serializedValue instanceof Supplier) {
            return FunctionsParameters.serializeValue(((Supplier)((Object)serializedValue)).get(), escapeStrings);
        }
        if (serializedValue instanceof VariableAssignment) {
            return ((VariableAssignment)((Object)serializedValue)).getVariableName();
        }
        return serializedValue.toString();
    }

    public void putPropertyNamed(@Nonnull String fluxName, @Nonnull String namedProperty) {
        Arguments.checkNonEmpty((String)fluxName, (String)"Flux property name");
        Arguments.checkNonEmpty((String)namedProperty, (String)"Named property");
        this.put(fluxName, new NamedProperty(namedProperty, DEFAULT_DELIMITER));
    }

    public void putFunctionNamed(@Nonnull String functionName, @Nonnull String namedProperty) {
        Arguments.checkNonEmpty((String)functionName, (String)"functionName");
        Arguments.checkNonEmpty((String)namedProperty, (String)"Named property");
        this.put(functionName, new NamedProperty(namedProperty, FUNCTION_DELIMITER));
    }

    public void putPropertyValue(@Nonnull String fluxName, final @Nullable Object value) {
        Arguments.checkNonEmpty((String)fluxName, (String)"Flux property name");
        if (value == null) {
            return;
        }
        this.put(fluxName, new AbstractProperty<Object>(){

            @Override
            @Nonnull
            public Object value(@Nonnull Map<String, Object> namedProperties) {
                return value;
            }
        });
    }

    public void putFunctionValue(@Nonnull String functionName, final @Nullable Object function) {
        Arguments.checkNonEmpty((String)functionName, (String)"functionName");
        if (function == null) {
            return;
        }
        this.put(functionName, new Property<Object>(){

            @Override
            @Nonnull
            public Object value(@Nonnull Map<String, Object> namedProperties) {
                return function;
            }

            @Override
            @Nonnull
            public String delimiter() {
                return FunctionsParameters.FUNCTION_DELIMITER;
            }
        });
    }

    public void putPropertyValue(@Nonnull String fluxName, @Nullable Long amount, @Nullable ChronoUnit unit) {
        Arguments.checkNonEmpty((String)fluxName, (String)"Flux property name");
        if (amount == null || unit == null) {
            return;
        }
        this.putPropertyValue(fluxName, new TimeInterval(amount, unit));
    }

    public void putPropertyValueString(@Nonnull String fluxName, @Nullable String value) {
        Arguments.checkNonEmpty((String)fluxName, (String)"Flux property name");
        if (value == null) {
            return;
        }
        this.put(fluxName, new StringProperty(value));
    }

    @Nonnull
    public Collection<String> keys() {
        return this.properties.keySet();
    }

    @Nullable
    public String get(@Nonnull String key, @Nonnull Map<String, Object> namedProperties) {
        Property<?> property = this.properties.get(key);
        if (property == null) {
            return null;
        }
        Object value = property.value(namedProperties);
        if (value == null) {
            return null;
        }
        return FunctionsParameters.serializeValue(value, false);
    }

    private void put(@Nonnull String name, @Nullable Property<?> property) {
        if (property == null) {
            return;
        }
        this.properties.put(name, property);
    }

    @Nonnull
    public String getDelimiter(@Nonnull String key) {
        Property<?> property = this.properties.get(key);
        if (property == null) {
            return DEFAULT_DELIMITER;
        }
        return property.delimiter();
    }

    static {
        DECIMAL_FORMAT.setMaximumFractionDigits(340);
    }

    private static final class NamedProperty<T>
    implements Property<T> {
        private final String parameterName;
        private final String delimiter;

        private NamedProperty(@Nonnull String parameterName, @Nonnull String delimiter) {
            Arguments.checkNonEmpty((String)parameterName, (String)"Parameter name");
            Arguments.checkNonEmpty((String)delimiter, (String)"delimiter");
            this.parameterName = parameterName;
            this.delimiter = delimiter;
        }

        @Override
        @Nonnull
        public T value(@Nonnull Map<String, Object> namedProperties) {
            Object parameterValue = namedProperties.get(this.parameterName);
            if (parameterValue == null) {
                String message = String.format("The parameter '%s' is not defined.", this.parameterName);
                throw new IllegalStateException(message);
            }
            return (T)parameterValue;
        }

        @Override
        @Nonnull
        public String delimiter() {
            return this.delimiter;
        }
    }

    private static interface Property<T> {
        @Nullable
        public T value(@Nonnull Map<String, Object> var1);

        @Nonnull
        public String delimiter();
    }

    private static final class StringProperty
    extends AbstractProperty<String> {
        private final String value;

        private StringProperty(@Nullable String value) {
            this.value = value;
        }

        @Override
        @Nullable
        public String value(@Nonnull Map<String, Object> namedProperties) {
            if (this.value == null) {
                return null;
            }
            return "\"" + FunctionsParameters.escapeDoubleQuotes(this.value) + "\"";
        }
    }

    private static abstract class AbstractProperty<T>
    implements Property<T> {
        private AbstractProperty() {
        }

        @Override
        @Nonnull
        public String delimiter() {
            return FunctionsParameters.DEFAULT_DELIMITER;
        }
    }
}

