/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.internal;

import com.influxdb.Arguments;
import com.influxdb.LogLevel;
import com.influxdb.exceptions.BadGatewayException;
import com.influxdb.exceptions.BadRequestException;
import com.influxdb.exceptions.ForbiddenException;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.exceptions.InternalServerErrorException;
import com.influxdb.exceptions.MethodNotAllowedException;
import com.influxdb.exceptions.NotAcceptableException;
import com.influxdb.exceptions.NotFoundException;
import com.influxdb.exceptions.NotImplementedException;
import com.influxdb.exceptions.PaymentRequiredException;
import com.influxdb.exceptions.ProxyAuthenticationRequiredException;
import com.influxdb.exceptions.RequestEntityTooLargeException;
import com.influxdb.exceptions.RequestTimeoutException;
import com.influxdb.exceptions.ServiceUnavailableException;
import com.influxdb.exceptions.UnauthorizedException;
import com.influxdb.exceptions.UnprocessableEntityException;
import java.io.EOFException;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Response;

public abstract class AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractRestClient.class.getName());
    private static final MediaType CONTENT_TYPE_JSON = MediaType.parse((String)"application/json");

    @Nonnull
    RequestBody createBody(@Nonnull String content) {
        Arguments.checkNonEmpty(content, "content");
        return RequestBody.create((MediaType)CONTENT_TYPE_JSON, (String)content);
    }

    protected <T> T execute(@Nonnull Call<T> call) throws InfluxException {
        Arguments.checkNotNull(call, "call");
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            throw this.responseToError(response);
        }
        catch (IOException e) {
            throw new InfluxException(e);
        }
    }

    @Nonnull
    protected InfluxException responseToError(@Nonnull Response<?> response) {
        Arguments.checkNotNull(response, "response");
        switch (response.code()) {
            case 400: {
                return new BadRequestException(response);
            }
            case 401: {
                return new UnauthorizedException(response);
            }
            case 402: {
                return new PaymentRequiredException(response);
            }
            case 403: {
                return new ForbiddenException(response);
            }
            case 404: {
                return new NotFoundException(response);
            }
            case 405: {
                return new MethodNotAllowedException(response);
            }
            case 406: {
                return new NotAcceptableException(response);
            }
            case 407: {
                return new ProxyAuthenticationRequiredException(response);
            }
            case 408: {
                return new RequestTimeoutException(response);
            }
            case 413: {
                return new RequestEntityTooLargeException(response);
            }
            case 422: {
                return new UnprocessableEntityException(response);
            }
            case 500: {
                return new InternalServerErrorException(response);
            }
            case 501: {
                return new NotImplementedException(response);
            }
            case 502: {
                return new BadGatewayException(response);
            }
            case 503: {
                return new ServiceUnavailableException(response);
            }
        }
        return new InfluxException(response);
    }

    void catchOrPropagateException(@Nonnull Exception exception, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(exception, "exception");
        Arguments.checkNotNull(onError, "onError");
        if (this.isCloseException(exception)) {
            LOG.log(Level.FINEST, "Socket closed by remote server or end of data", exception);
        } else {
            onError.accept(exception);
        }
    }

    protected void setLogLevel(@Nonnull HttpLoggingInterceptor interceptor, @Nonnull LogLevel logLevel) {
        Arguments.checkNotNull((Object)logLevel, "LogLevel");
        Arguments.checkNotNull(interceptor, "HttpLogging interceptor");
        interceptor.setLevel(HttpLoggingInterceptor.Level.valueOf((String)logLevel.name()));
    }

    @Nonnull
    protected LogLevel getLogLevel(@Nonnull HttpLoggingInterceptor interceptor) {
        Arguments.checkNotNull(interceptor, "HttpLogging interceptor");
        return LogLevel.valueOf(interceptor.getLevel().name());
    }

    private boolean isCloseException(@Nonnull Exception exception) {
        Arguments.checkNotNull(exception, "exception");
        return exception instanceof EOFException;
    }
}

