/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.internal;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class UserAgentInterceptor
implements Interceptor {
    private final String userAgent;

    public UserAgentInterceptor() {
        Package mainPackage = UserAgentInterceptor.class.getPackage();
        String version = mainPackage.getImplementationVersion();
        this.userAgent = "influxdb-client-java/" + (version != null ? version : "unknown");
    }

    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder().header("User-Agent", this.userAgent);
        return chain.proceed(builder.build());
    }
}

