/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.internal;

import com.influxdb.Cancellable;
import com.influxdb.query.FluxColumn;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.exceptions.FluxCsvParserException;
import com.influxdb.query.exceptions.FluxQueryException;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class FluxCsvParser {
    private static final String ANNOTATION_DATATYPE = "#datatype";
    private static final String ANNOTATION_GROUP = "#group";
    private static final String ANNOTATION_DEFAULT = "#default";
    private static final List<String> ANNOTATIONS = Arrays.asList("#datatype", "#group", "#default");

    public void parseFluxResponse(@Nonnull BufferedSource bufferedSource, @Nonnull Cancellable cancellable, @Nonnull FluxResponseConsumer consumer) throws IOException {
        Arguments.checkNotNull((Object)bufferedSource, (String)"bufferedSource");
        InputStreamReader reader = new InputStreamReader(bufferedSource.inputStream(), StandardCharsets.UTF_8);
        FluxCsvState state = new FluxCsvState();
        try (CSVParser parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);){
            for (CSVRecord csvRecord : parser) {
                if (cancellable.isCancelled()) {
                    return;
                }
                state.csvRecord = csvRecord;
                FluxRecordOrTable fluxRecordOrTable = this.parseNextResponse(state);
                if (fluxRecordOrTable.table != null) {
                    consumer.accept(state.tableIndex - 1, cancellable, fluxRecordOrTable.table);
                }
                if (fluxRecordOrTable.record == null) continue;
                consumer.accept(state.tableIndex - 1, cancellable, fluxRecordOrTable.record);
            }
        }
    }

    @Nonnull
    public FluxRecordOrTable parseNextResponse(@Nonnull FluxCsvState state) {
        FluxRecordOrTable result = new FluxRecordOrTable();
        CSVRecord csvRecord = state.csvRecord;
        if (csvRecord.size() >= 3 && csvRecord.get(1).equals("error") && csvRecord.get(2).equals("reference")) {
            state.parsingState = ParsingState.IN_ERROR;
            return result;
        }
        if (ParsingState.IN_ERROR.equals((Object)state.parsingState)) {
            String error = csvRecord.get(1);
            String referenceValue = csvRecord.get(2);
            int reference = 0;
            if (referenceValue != null && !referenceValue.isEmpty()) {
                reference = Integer.parseInt(referenceValue);
            }
            throw new FluxQueryException(error, reference);
        }
        String token = csvRecord.get(0);
        if (ANNOTATIONS.contains(token) && !state.startNewTable) {
            state.startNewTable = true;
            state.table = new FluxTable();
            state.groups = Collections.emptyList();
            result.table = state.table;
            state.tableIndex++;
            state.tableId = -1;
        } else if (state.table == null) {
            String message = "Unable to parse CSV response. FluxTable definition was not found.";
            throw new FluxCsvParserException(message);
        }
        if (ANNOTATION_DATATYPE.equals(token)) {
            this.addDataTypes(state.table, this.toList(csvRecord));
        } else if (ANNOTATION_GROUP.equals(token)) {
            state.groups = this.toList(csvRecord);
        } else if (ANNOTATION_DEFAULT.equals(token)) {
            this.addDefaultEmptyValues(state.table, this.toList(csvRecord));
        } else {
            if (state.startNewTable) {
                this.addGroups(state.table, state.groups);
                this.addColumnNamesAndTags(state.table, this.toList(csvRecord));
                state.startNewTable = false;
                return result;
            }
            int currentId = Integer.parseInt(csvRecord.get(2));
            if (state.tableId == -1) {
                state.tableId = currentId;
            }
            if (state.tableId != currentId) {
                List<FluxColumn> fluxColumns = state.table.getColumns();
                state.table = new FluxTable();
                state.table.getColumns().addAll(fluxColumns);
                result.table = state.table;
                state.tableIndex++;
                state.tableId = currentId;
            }
            result.record = this.parseRecord(state.tableIndex - 1, state.table, csvRecord);
        }
        return result;
    }

    private FluxRecord parseRecord(int tableIndex, FluxTable table, CSVRecord csvRecord) {
        FluxRecord record = new FluxRecord(tableIndex);
        for (FluxColumn fluxColumn : table.getColumns()) {
            String columnName = fluxColumn.getLabel();
            String strValue = csvRecord.get(fluxColumn.getIndex() + 1);
            record.getValues().put(columnName, this.toValue(strValue, fluxColumn));
        }
        return record;
    }

    @Nonnull
    private List<String> toList(CSVRecord csvRecord) {
        ArrayList<String> ret = new ArrayList<String>(csvRecord.size());
        int size = csvRecord.size();
        for (int i = 1; i < size; ++i) {
            String rec = csvRecord.get(i);
            ret.add(rec);
        }
        return ret;
    }

    @Nullable
    private Object toValue(@Nullable String strValue, @Nonnull FluxColumn column) {
        String dataType;
        Arguments.checkNotNull((Object)column, (String)"column");
        if (strValue == null || strValue.isEmpty()) {
            String defaultValue = column.getDefaultValue();
            if (defaultValue == null || defaultValue.isEmpty()) {
                return null;
            }
            return this.toValue(defaultValue, column);
        }
        switch (dataType = column.getDataType()) {
            case "boolean": {
                return Boolean.valueOf(strValue);
            }
            case "unsignedLong": {
                return Long.parseUnsignedLong(strValue);
            }
            case "long": {
                return Long.parseLong(strValue);
            }
            case "double": {
                switch (strValue) {
                    case "+Inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-Inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                return Double.parseDouble(strValue);
            }
            case "base64Binary": {
                return Base64.getDecoder().decode(strValue);
            }
            case "dateTime:RFC3339": 
            case "dateTime:RFC3339Nano": {
                return Instant.parse(strValue);
            }
            case "duration": {
                return Duration.ofNanos(Long.parseUnsignedLong(strValue));
            }
        }
        return strValue;
    }

    private void addDataTypes(@Nonnull FluxTable table, @Nonnull List<String> dataTypes) {
        Arguments.checkNotNull((Object)table, (String)"table");
        Arguments.checkNotNull(dataTypes, (String)"dataTypes");
        for (int index = 0; index < dataTypes.size(); ++index) {
            String dataType = dataTypes.get(index);
            FluxColumn columnDef = new FluxColumn();
            columnDef.setDataType(dataType);
            columnDef.setIndex(index);
            table.getColumns().add(columnDef);
        }
    }

    private void addGroups(@Nonnull FluxTable table, @Nonnull List<String> groups) {
        Arguments.checkNotNull((Object)table, (String)"table");
        Arguments.checkNotNull(groups, (String)"groups");
        for (int i = 0; i < table.getColumns().size(); ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String group = groups.get(i);
            fluxColumn.setGroup(Boolean.parseBoolean(group));
        }
    }

    private void addDefaultEmptyValues(@Nonnull FluxTable table, @Nonnull List<String> defaultEmptyValues) {
        Arguments.checkNotNull((Object)table, (String)"table");
        Arguments.checkNotNull(defaultEmptyValues, (String)"defaultEmptyValues");
        for (int i = 0; i < defaultEmptyValues.size(); ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String defaultValue = defaultEmptyValues.get(i);
            fluxColumn.setDefaultValue(defaultValue);
        }
    }

    private void addColumnNamesAndTags(@Nonnull FluxTable table, @Nonnull List<String> columnNames) {
        Arguments.checkNotNull((Object)table, (String)"table");
        Arguments.checkNotNull(columnNames, (String)"columnNames");
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            FluxColumn fluxColumn = this.getFluxColumn(i, table);
            String columnName = columnNames.get(i);
            fluxColumn.setLabel(columnName);
        }
    }

    @Nonnull
    private FluxColumn getFluxColumn(int columnIndex, @Nonnull FluxTable table) {
        Arguments.checkNotNull((Object)table, (String)"table");
        return table.getColumns().get(columnIndex);
    }

    public static class FluxRecordOrTable {
        public FluxRecord record;
        public FluxTable table;
    }

    public static class FluxCsvState {
        private ParsingState parsingState = ParsingState.NORMAL;
        private int tableIndex = 0;
        private int tableId = -1;
        private boolean startNewTable = false;
        private FluxTable table = null;
        private List<String> groups = Collections.emptyList();
        public CSVRecord csvRecord;
    }

    public class FluxResponseConsumerTable
    implements FluxResponseConsumer {
        private List<FluxTable> tables = new ArrayList<FluxTable>();

        @Override
        public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            this.tables.add(index, table);
        }

        @Override
        public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
            this.tables.get(index).getRecords().add(record);
        }

        @Nonnull
        public List<FluxTable> getTables() {
            return this.tables;
        }
    }

    public static interface FluxResponseConsumer {
        public void accept(int var1, @Nonnull Cancellable var2, @Nonnull FluxTable var3);

        public void accept(int var1, @Nonnull Cancellable var2, @Nonnull FluxRecord var3);
    }

    private static enum ParsingState {
        NORMAL,
        IN_ERROR;

    }
}

