/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.internal;

import com.influxdb.annotations.Column;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.query.FluxRecord;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FluxResultMapper {
    private static final Pattern CAMEL_CASE_TO_SNAKE_CASE_REPLACE_PATTERN = Pattern.compile("[A-Z]");

    @Nonnull
    public <T> T toPOJO(@Nonnull FluxRecord record, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(record, "Record is required");
        Objects.requireNonNull(clazz, "Class type is required");
        try {
            T pojo = clazz.newInstance();
            for (Class<T> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = currentClazz.getDeclaredFields()) {
                    Column anno = field.getAnnotation(Column.class);
                    String columnName = field.getName();
                    if (anno != null && !anno.name().isEmpty()) {
                        columnName = anno.name();
                    }
                    Map<String, Object> recordValues = record.getValues();
                    String col = null;
                    if (recordValues.containsKey(columnName)) {
                        col = columnName;
                    } else if (recordValues.containsKey("_" + columnName)) {
                        col = "_" + columnName;
                    } else if (anno != null && anno.measurement()) {
                        col = "_measurement";
                    } else {
                        String columnNameInSnakeCase = this.camelCaseToSnakeCase(columnName);
                        if (recordValues.containsKey(columnNameInSnakeCase)) {
                            col = columnNameInSnakeCase;
                        }
                    }
                    if (col == null) continue;
                    Object value = record.getValueByKey(col);
                    this.setFieldValue(pojo, field, value);
                }
            }
            return pojo;
        }
        catch (Exception e) {
            throw new InfluxException(e);
        }
    }

    private String camelCaseToSnakeCase(String str) {
        return CAMEL_CASE_TO_SNAKE_CASE_REPLACE_PATTERN.matcher(str).replaceAll("_$0").toLowerCase();
    }

    private void setFieldValue(@Nonnull Object object, @Nullable Field field, @Nullable Object value) {
        if (field == null || value == null) {
            return;
        }
        String msg = "Class '%s' field '%s' was defined with a different field type and caused a ClassCastException. The correct type is '%s' (current field value: '%s').";
        try {
            Class<?> fieldType;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((fieldType = field.getType()).equals(value.getClass())) {
                field.set(object, value);
                return;
            }
            if (Double.TYPE.isAssignableFrom(fieldType)) {
                field.setDouble(object, this.toDoubleValue(value));
                return;
            }
            if (Long.TYPE.isAssignableFrom(fieldType)) {
                field.setLong(object, this.toLongValue(value));
                return;
            }
            if (Integer.TYPE.isAssignableFrom(fieldType)) {
                field.setInt(object, this.toIntValue(value));
                return;
            }
            if (Boolean.TYPE.isAssignableFrom(fieldType)) {
                field.setBoolean(object, Boolean.valueOf(String.valueOf(value)));
                return;
            }
            if (BigDecimal.class.isAssignableFrom(fieldType)) {
                field.set(object, this.toBigDecimalValue(value));
                return;
            }
            if (fieldType.isEnum()) {
                field.set(object, Enum.valueOf(fieldType, String.valueOf(value)));
                return;
            }
            field.set(object, value);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new InfluxException(String.format(msg, object.getClass().getName(), field.getName(), value.getClass().getName(), value));
        }
    }

    private double toDoubleValue(Object value) {
        if (Double.TYPE.isAssignableFrom(value.getClass()) || Double.class.isAssignableFrom(value.getClass())) {
            return (Double)value;
        }
        return (Double)value;
    }

    private long toLongValue(Object value) {
        if (Long.TYPE.isAssignableFrom(value.getClass()) || Long.class.isAssignableFrom(value.getClass())) {
            return (Long)value;
        }
        return ((Double)value).longValue();
    }

    private int toIntValue(Object value) {
        if (Integer.TYPE.isAssignableFrom(value.getClass()) || Integer.class.isAssignableFrom(value.getClass())) {
            return (Integer)value;
        }
        return ((Double)value).intValue();
    }

    private BigDecimal toBigDecimalValue(Object value) {
        if (String.class.isAssignableFrom(value.getClass())) {
            return new BigDecimal((String)value);
        }
        if (Double.TYPE.isAssignableFrom(value.getClass()) || Double.class.isAssignableFrom(value.getClass())) {
            return BigDecimal.valueOf((Double)value);
        }
        if (Integer.TYPE.isAssignableFrom(value.getClass()) || Integer.class.isAssignableFrom(value.getClass())) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (Long.TYPE.isAssignableFrom(value.getClass()) || Long.class.isAssignableFrom(value.getClass())) {
            return BigDecimal.valueOf((Long)value);
        }
        String message = String.format("Cannot cast %s [%s] to %s.", value.getClass().getName(), value, BigDecimal.class);
        throw new ClassCastException(message);
    }
}

