/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.flux;

import com.influxdb.Arguments;
import com.influxdb.exceptions.InfluxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

@ThreadSafe
public final class FluxConnectionOptions {
    private final String url;
    private OkHttpClient.Builder okHttpClient;
    private Map<String, String> parameters;

    private FluxConnectionOptions(@Nonnull Builder builder) {
        Arguments.checkNotNull((Object)builder, (String)"FluxConnectionOptions.Builder");
        this.url = builder.url;
        this.okHttpClient = builder.okHttpClient;
        this.parameters = builder.parameters;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String connectionString) {
        Builder builder = new Builder();
        HttpUrl parse = HttpUrl.parse((String)connectionString);
        if (parse == null) {
            throw new InfluxException("Unable to parse connection string " + connectionString);
        }
        HttpUrl url = parse.newBuilder().build();
        String urlWithoutParams = url.scheme() + "://" + url.host() + ":" + url.port() + url.encodedPath();
        if (!urlWithoutParams.endsWith("/")) {
            urlWithoutParams = urlWithoutParams + "/";
        }
        builder.url(urlWithoutParams);
        Set parameters = url.queryParameterNames();
        parameters.forEach(paramName -> builder.withParam((String)paramName, url.queryParameter(paramName)));
        return builder;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public OkHttpClient.Builder getOkHttpClient() {
        return this.okHttpClient;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @NotThreadSafe
    public static class Builder {
        private String url;
        private OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        private Map<String, String> parameters = new HashMap<String, String>();

        @Nonnull
        public Builder url(@Nonnull String url) {
            Arguments.checkNonEmpty((String)url, (String)"url");
            this.url = url;
            return this;
        }

        public Builder withParam(@Nonnull String paramName, @Nullable String value) {
            Arguments.checkNotNull((Object)paramName, (String)"paramName");
            Arguments.checkNotNull((Object)value, (String)"value");
            this.parameters.put(paramName, value);
            return this;
        }

        @Nonnull
        public Builder okHttpClient(@Nonnull OkHttpClient.Builder okHttpClient) {
            Arguments.checkNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder");
            this.okHttpClient = okHttpClient;
            return this;
        }

        @Nonnull
        public FluxConnectionOptions build() {
            if (this.url == null) {
                throw new IllegalStateException("The url to connect to Flux has to be defined.");
            }
            this.parameters.forEach((key, value) -> {
                switch (key) {
                    case "readTimeout": {
                        this.okHttpClient.readTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "writeTimeout": {
                        this.okHttpClient.writeTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "connectTimeout": {
                        this.okHttpClient.connectTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        break;
                    }
                    case "logLevel": {
                        break;
                    }
                    default: {
                        throw new InfluxException("Invalid connection string parameter: " + key);
                    }
                }
            });
            return new FluxConnectionOptions(this);
        }
    }
}

