/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.flux.internal;

import com.influxdb.Cancellable;
import com.influxdb.LogLevel;
import com.influxdb.client.flux.FluxClient;
import com.influxdb.client.flux.FluxConnectionOptions;
import com.influxdb.client.flux.internal.FluxService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.internal.UserAgentInterceptor;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.internal.FluxCsvParser;
import com.influxdb.utils.Arguments;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Retrofit;

public class FluxApiImpl
extends AbstractQueryApi
implements FluxClient {
    private final FluxService fluxService;
    private final HttpLoggingInterceptor loggingInterceptor;
    private final OkHttpClient okHttpClient;

    public FluxApiImpl(@Nonnull FluxConnectionOptions options) {
        Arguments.checkNotNull((Object)options, (String)"options");
        this.loggingInterceptor = new HttpLoggingInterceptor();
        String logLevelParam = options.getParameters().get("logLevel");
        if (logLevelParam == null) {
            this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        } else {
            this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.valueOf((String)logLevelParam));
        }
        this.okHttpClient = options.getOkHttpClient().addInterceptor((Interceptor)new UserAgentInterceptor("java")).addInterceptor((Interceptor)this.loggingInterceptor).build();
        Retrofit.Builder serviceBuilder = new Retrofit.Builder().baseUrl(options.getUrl()).client(this.okHttpClient);
        this.fluxService = (FluxService)serviceBuilder.build().create(FluxService.class);
    }

    @Override
    @Nonnull
    public List<FluxTable> query(@Nonnull String query) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        FluxCsvParser.FluxResponseConsumerTable consumer = new FluxCsvParser.FluxResponseConsumerTable(this.fluxCsvParser);
        this.query(query, DEFAULT_DIALECT, (FluxCsvParser.FluxResponseConsumer)consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return consumer.getTables();
    }

    @Override
    @Nonnull
    public <M> List<M> query(@Nonnull String query, final @Nonnull Class<M> measurementType) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(measurementType, (String)"measurementType");
        final ArrayList measurements = new ArrayList();
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                measurements.add(FluxApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(query, DEFAULT_DIALECT, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return measurements;
    }

    @Override
    public void query(@Nonnull String query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        this.query(query, onNext, ERROR_CONSUMER);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        Arguments.checkNotNull(measurementType, (String)"measurementType");
        this.query(query, measurementType, onNext, ERROR_CONSUMER);
    }

    @Override
    public void query(@Nonnull String query, @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        this.query(query, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public <M> void query(@Nonnull String query, @Nonnull Class<M> measurementType, @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull(measurementType, (String)"measurementType");
        this.query(query, measurementType, onNext, onError, EMPTY_ACTION);
    }

    @Override
    public void query(@Nonnull String query, final @Nonnull BiConsumer<Cancellable, FluxRecord> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, record);
            }
        };
        this.query(query, DEFAULT_DIALECT, consumer, onError, onComplete, true);
    }

    @Override
    public <M> void query(@Nonnull String query, final @Nonnull Class<M> measurementType, final @Nonnull BiConsumer<Cancellable, M> onNext, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        Arguments.checkNotNull(measurementType, (String)"measurementType");
        FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
            }

            public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                onNext.accept(cancellable, FluxApiImpl.this.resultMapper.toPOJO(record, measurementType));
            }
        };
        this.query(query, DEFAULT_DIALECT, consumer, onError, onComplete, true);
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        return this.queryRaw(query, (String)null);
    }

    @Override
    @Nonnull
    public String queryRaw(@Nonnull String query, @Nullable String dialect) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        ArrayList rows = new ArrayList();
        BiConsumer<Cancellable, String> consumer = (cancellable, row) -> rows.add(row);
        this.queryRaw(query, dialect, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return String.join((CharSequence)"\n", rows);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onResponse, (String)"onNext");
        this.queryRaw(query, null, onResponse);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable String dialect, @Nonnull BiConsumer<Cancellable, String> onNext) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onNext, (String)"onNext");
        this.queryRaw(query, dialect, onNext, ERROR_CONSUMER);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onResponse, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        this.queryRaw(query, onResponse, onError, EMPTY_ACTION);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable String dialect, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onResponse, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        this.queryRaw(query, dialect, onResponse, onError, EMPTY_ACTION);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onResponse, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        this.queryRaw(query, null, onResponse, onError, onComplete);
    }

    @Override
    public void queryRaw(@Nonnull String query, @Nullable String dialect, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete) {
        Arguments.checkNonEmpty((String)query, (String)"query");
        Arguments.checkNotNull(onResponse, (String)"onNext");
        Arguments.checkNotNull(onError, (String)"onError");
        Arguments.checkNotNull((Object)onComplete, (String)"onComplete");
        this.queryRaw(query, dialect, onResponse, onError, onComplete, true);
    }

    @Override
    @Nonnull
    public Boolean ping() {
        return this.ping(this.fluxService.ping());
    }

    @Override
    @Nonnull
    public String version() {
        return this.version(this.fluxService.ping());
    }

    @Override
    @Nonnull
    public LogLevel getLogLevel() {
        return this.getLogLevel(this.loggingInterceptor);
    }

    @Override
    @Nonnull
    public FluxClient setLogLevel(@Nonnull LogLevel logLevel) {
        Arguments.checkNotNull((Object)logLevel, (String)"LogLevel");
        this.setLogLevel(this.loggingInterceptor, logLevel);
        return this;
    }

    @Override
    public void close() {
        this.okHttpClient.connectionPool().evictAll();
        this.okHttpClient.dispatcher().executorService().shutdown();
    }

    private void query(@Nonnull String query, @Nonnull String dialect, @Nonnull FluxCsvParser.FluxResponseConsumer responseConsumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Call<ResponseBody> queryCall = this.fluxService.query(this.createBody(dialect, query));
        this.query(queryCall, responseConsumer, onError, onComplete, asynchronously);
    }

    private void queryRaw(@Nonnull String query, @Nullable String dialect, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Call<ResponseBody> queryCall = this.fluxService.query(this.createBody(dialect, query));
        this.queryRaw(queryCall, onResponse, onError, onComplete, asynchronously);
    }
}

