/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Color defines an encoding of data value into color space")
public class DashboardColor {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_HEX = "hex";
    @SerializedName(value="hex")
    private String hex;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Float value;

    public DashboardColor id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="ID is the unique id of the view color")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DashboardColor type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type is how the color is used.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DashboardColor hex(String hex) {
        this.hex = hex;
        return this;
    }

    @ApiModelProperty(required=true, value="Hex is the hex number of the color")
    public String getHex() {
        return this.hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    public DashboardColor name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the user-facing name of the hex color")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DashboardColor value(Float value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Value is the data value mapped to this color")
    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardColor dashboardColor = (DashboardColor)o;
        return Objects.equals(this.id, dashboardColor.id) && Objects.equals((Object)this.type, (Object)dashboardColor.type) && Objects.equals(this.hex, dashboardColor.hex) && Objects.equals(this.name, dashboardColor.name) && Objects.equals(this.value, dashboardColor.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.hex, this.name, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardColor {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    hex: ").append(this.toIndentedString(this.hex)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        MIN("min"),
        MAX("max"),
        THRESHOLD("threshold"),
        SCALE("scale"),
        TEXT("text"),
        BACKGROUND("background");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

