/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.DocumentMeta;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentCreate {
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private DocumentMeta meta = null;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private Object content = null;
    public static final String SERIALIZED_NAME_ORG = "org";
    @SerializedName(value="org")
    private String org;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<String> labels = new ArrayList<String>();

    public DocumentCreate meta(DocumentMeta meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentMeta getMeta() {
        return this.meta;
    }

    public void setMeta(DocumentMeta meta) {
        this.meta = meta;
    }

    public DocumentCreate content(Object content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public DocumentCreate org(String org) {
        this.org = org;
        return this;
    }

    @ApiModelProperty(value="must specify one of orgID and org")
    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public DocumentCreate orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="must specify one of orgID and org")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public DocumentCreate labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public DocumentCreate addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="this is an array of label IDs that will be added as labels to the document")
    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCreate documentCreate = (DocumentCreate)o;
        return Objects.equals(this.meta, documentCreate.meta) && Objects.equals(this.content, documentCreate.content) && Objects.equals(this.org, documentCreate.org) && Objects.equals(this.orgID, documentCreate.orgID) && Objects.equals(this.labels, documentCreate.labels);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.content, this.org, this.orgID, this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentCreate {\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

