/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.Expression;
import com.influxdb.client.domain.Property;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="allows the declaration of an anonymous object within a declaration")
public class ObjectExpression
extends Expression {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    private List<Property> properties = new ArrayList<Property>();

    public ObjectExpression type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="type of AST node")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ObjectExpression properties(List<Property> properties) {
        this.properties = properties;
        return this;
    }

    public ObjectExpression addPropertiesItem(Property propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="object properties")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectExpression objectExpression = (ObjectExpression)o;
        return Objects.equals(this.type, objectExpression.type) && Objects.equals(this.properties, objectExpression.properties) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.properties, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectExpression {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

