/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Dialect;
import com.influxdb.client.domain.File;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="query influx with specified return formatting.")
public class Query {
    public static final String SERIALIZED_NAME_EXTERN = "extern";
    @SerializedName(value="extern")
    private File extern = null;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.FLUX;
    public static final String SERIALIZED_NAME_DB = "db";
    @SerializedName(value="db")
    private String db;
    public static final String SERIALIZED_NAME_RP = "rp";
    @SerializedName(value="rp")
    private String rp;
    public static final String SERIALIZED_NAME_CLUSTER = "cluster";
    @SerializedName(value="cluster")
    private String cluster;
    public static final String SERIALIZED_NAME_DIALECT = "dialect";
    @SerializedName(value="dialect")
    private Dialect dialect = null;

    public Query extern(File extern) {
        this.extern = extern;
        return this;
    }

    @ApiModelProperty(value="")
    public File getExtern() {
        return this.extern;
    }

    public void setExtern(File extern) {
        this.extern = extern;
    }

    public Query query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="query script to execute.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="type of query")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Query db(String db) {
        this.db = db;
        return this;
    }

    @ApiModelProperty(value="required for influxql type queries")
    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public Query rp(String rp) {
        this.rp = rp;
        return this;
    }

    @ApiModelProperty(value="required for influxql type queries")
    public String getRp() {
        return this.rp;
    }

    public void setRp(String rp) {
        this.rp = rp;
    }

    public Query cluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    @ApiModelProperty(value="required for influxql type queries")
    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public Query dialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    @ApiModelProperty(value="")
    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.extern, query.extern) && Objects.equals(this.query, query.query) && Objects.equals((Object)this.type, (Object)query.type) && Objects.equals(this.db, query.db) && Objects.equals(this.rp, query.rp) && Objects.equals(this.cluster, query.cluster) && Objects.equals(this.dialect, query.dialect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extern, this.query, this.type, this.db, this.rp, this.cluster, this.dialect});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Query {\n");
        sb.append("    extern: ").append(this.toIndentedString(this.extern)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    db: ").append(this.toIndentedString(this.db)).append("\n");
        sb.append("    rp: ").append(this.toIndentedString(this.rp)).append("\n");
        sb.append("    cluster: ").append(this.toIndentedString(this.cluster)).append("\n");
        sb.append("    dialect: ").append(this.toIndentedString(this.dialect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FLUX("flux"),
        INFLUXQL("influxql");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

