/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.TelegrafPluginInputCpu;
import com.influxdb.client.domain.TelegrafPluginInputDisk;
import com.influxdb.client.domain.TelegrafPluginInputDiskio;
import com.influxdb.client.domain.TelegrafPluginInputDocker;
import com.influxdb.client.domain.TelegrafPluginInputFile;
import com.influxdb.client.domain.TelegrafPluginInputKubernetes;
import com.influxdb.client.domain.TelegrafPluginInputLogParser;
import com.influxdb.client.domain.TelegrafPluginInputProcstat;
import com.influxdb.client.domain.TelegrafPluginInputPrometheus;
import com.influxdb.client.domain.TelegrafPluginInputRedis;
import com.influxdb.client.domain.TelegrafPluginInputSyslog;
import com.influxdb.client.domain.TelegrafPluginOutputFile;
import com.influxdb.client.domain.TelegrafPluginOutputInfluxDBV2;
import com.influxdb.client.domain.TelegrafRequestAgent;
import com.influxdb.client.domain.TelegrafRequestPlugin;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TelegrafRequest {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_AGENT = "agent";
    @SerializedName(value="agent")
    private TelegrafRequestAgent agent = null;
    public static final String SERIALIZED_NAME_PLUGINS = "plugins";
    @SerializedName(value="plugins")
    @JsonAdapter(value=TelegrafRequestPluginsAdapter.class)
    private List<TelegrafRequestPlugin> plugins = new ArrayList<TelegrafRequestPlugin>();
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;

    public TelegrafRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TelegrafRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TelegrafRequest agent(TelegrafRequestAgent agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(value="")
    public TelegrafRequestAgent getAgent() {
        return this.agent;
    }

    public void setAgent(TelegrafRequestAgent agent) {
        this.agent = agent;
    }

    public TelegrafRequest plugins(List<TelegrafRequestPlugin> plugins) {
        this.plugins = plugins;
        return this;
    }

    public TelegrafRequest addPluginsItem(TelegrafRequestPlugin pluginsItem) {
        if (this.plugins == null) {
            this.plugins = new ArrayList<TelegrafRequestPlugin>();
        }
        this.plugins.add(pluginsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TelegrafRequestPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<TelegrafRequestPlugin> plugins) {
        this.plugins = plugins;
    }

    public TelegrafRequest orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelegrafRequest telegrafRequest = (TelegrafRequest)o;
        return Objects.equals(this.name, telegrafRequest.name) && Objects.equals(this.description, telegrafRequest.description) && Objects.equals(this.agent, telegrafRequest.agent) && Objects.equals(this.plugins, telegrafRequest.plugins) && Objects.equals(this.orgID, telegrafRequest.orgID);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.agent, this.plugins, this.orgID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelegrafRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    plugins: ").append(this.toIndentedString(this.plugins)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public class TelegrafRequestPluginsAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(TelegrafRequest.SERIALIZED_NAME_NAME, "type");
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement arrayItem : json.getAsJsonArray()) {
                JsonObject jsonObject = arrayItem.getAsJsonObject();
                String[] types = (String[])discriminator.stream().map(d -> jsonObject.get(d).getAsString()).toArray(String[]::new);
                results.add(this.deserialize(types, (JsonElement)jsonObject, context));
            }
            return results;
        }

        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"cpu", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputCpu.class);
            }
            if (Arrays.equals(new String[]{"disk", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputDisk.class);
            }
            if (Arrays.equals(new String[]{"diskio", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputDiskio.class);
            }
            if (Arrays.equals(new String[]{"docker", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputDocker.class);
            }
            if (Arrays.equals(new String[]{"file", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputFile.class);
            }
            if (Arrays.equals(new String[]{"kubernetes", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputKubernetes.class);
            }
            if (Arrays.equals(new String[]{"logparser", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputLogParser.class);
            }
            if (Arrays.equals(new String[]{"procstat", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputProcstat.class);
            }
            if (Arrays.equals(new String[]{"prometheus", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputPrometheus.class);
            }
            if (Arrays.equals(new String[]{"redis", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputRedis.class);
            }
            if (Arrays.equals(new String[]{"syslog", "input"}, types)) {
                return context.deserialize(json, TelegrafPluginInputSyslog.class);
            }
            if (Arrays.equals(new String[]{"file", "output"}, types)) {
                return context.deserialize(json, TelegrafPluginOutputFile.class);
            }
            if (Arrays.equals(new String[]{"influxdb_v2", "output"}, types)) {
                return context.deserialize(json, TelegrafPluginOutputInfluxDBV2.class);
            }
            return context.deserialize(json, Object.class);
        }
    }
}

