/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.TelegrafsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Telegraf;
import com.influxdb.client.domain.TelegrafRequest;
import com.influxdb.client.domain.TelegrafRequestAgent;
import com.influxdb.client.domain.TelegrafRequestPlugin;
import com.influxdb.client.domain.Telegrafs;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.TelegrafsService;
import com.influxdb.internal.AbstractRestClient;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class TelegrafsApiImpl
extends AbstractRestClient
implements TelegrafsApi {
    private static final Logger LOG = Logger.getLogger(TelegrafsApiImpl.class.getName());
    private final TelegrafsService service;

    TelegrafsApiImpl(@Nonnull TelegrafsService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull TelegrafRequest telegrafRequest) {
        Arguments.checkNotNull((Object)telegrafRequest, (String)"telegrafRequest");
        Call<Telegraf> call = this.service.postTelegrafs(telegrafRequest, null);
        return (Telegraf)this.execute(call);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull String orgID, @Nonnull Integer collectionInterval, TelegrafRequestPlugin ... plugins) {
        Arguments.checkNonEmpty((String)name, (String)"TelegrafConfig.name");
        Arguments.checkNonEmpty((String)orgID, (String)"TelegrafConfig.orgID");
        Arguments.checkPositiveNumber((Number)collectionInterval, (String)"TelegrafConfig.collectionInterval");
        return this.createTelegraf(name, description, orgID, collectionInterval, Arrays.asList(plugins));
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull Organization org, @Nonnull Integer collectionInterval, TelegrafRequestPlugin ... plugins) {
        Arguments.checkNonEmpty((String)name, (String)"TelegrafConfig.name");
        Arguments.checkNotNull((Object)org, (String)"TelegrafConfig.org");
        Arguments.checkPositiveNumber((Number)collectionInterval, (String)"TelegrafConfig.collectionInterval");
        return this.createTelegraf(name, description, org.getId(), collectionInterval, plugins);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull Organization org, @Nonnull Integer collectionInterval, @Nonnull List<TelegrafRequestPlugin> plugins) {
        Arguments.checkNonEmpty((String)name, (String)"TelegrafConfig.name");
        Arguments.checkNotNull((Object)org, (String)"TelegrafConfig.org");
        Arguments.checkPositiveNumber((Number)collectionInterval, (String)"TelegrafConfig.collectionInterval");
        return this.createTelegraf(name, description, org.getId(), collectionInterval, plugins);
    }

    @Override
    @Nonnull
    public Telegraf createTelegraf(@Nonnull String name, @Nullable String description, @Nonnull String orgID, @Nonnull Integer collectionInterval, @Nonnull List<TelegrafRequestPlugin> plugins) {
        Arguments.checkNonEmpty((String)name, (String)"TelegrafConfig.name");
        Arguments.checkNonEmpty((String)orgID, (String)"TelegrafConfig.orgID");
        Arguments.checkPositiveNumber((Number)collectionInterval, (String)"TelegrafConfig.collectionInterval");
        TelegrafRequestAgent telegrafAgent = new TelegrafRequestAgent();
        telegrafAgent.setCollectionInterval(collectionInterval);
        TelegrafRequest telegrafConfig = new TelegrafRequest();
        telegrafConfig.setName(name);
        telegrafConfig.setDescription(description);
        telegrafConfig.setOrgID(orgID);
        telegrafConfig.setAgent(telegrafAgent);
        telegrafConfig.plugins(plugins);
        return this.createTelegraf(telegrafConfig);
    }

    @Override
    @Nonnull
    public Telegraf updateTelegraf(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"TelegrafConfig");
        TelegrafRequest telegrafRequest = this.toTelegrafRequest(telegraf);
        return this.updateTelegraf(telegraf.getId(), telegrafRequest);
    }

    @Override
    @Nonnull
    public Telegraf updateTelegraf(@Nonnull String telegrafID, @Nonnull TelegrafRequest telegrafRequest) {
        Arguments.checkNotNull((Object)telegrafRequest, (String)"TelegrafRequest");
        Call<Telegraf> telegrafConfigCall = this.service.putTelegrafsID(telegrafID, telegrafRequest, null);
        return (Telegraf)this.execute(telegrafConfigCall);
    }

    @Override
    public void deleteTelegraf(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"TelegrafConfig");
        this.deleteTelegraf(telegraf.getId());
    }

    @Override
    public void deleteTelegraf(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"telegrafConfigID");
        Call<Void> call = this.service.deleteTelegrafsID(telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Telegraf cloneTelegraf(@Nonnull String clonedName, @Nonnull String telegrafConfigID) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNonEmpty((String)telegrafConfigID, (String)"telegrafConfigID");
        Telegraf telegrafConfig = this.findTelegrafByID(telegrafConfigID);
        return this.cloneTelegraf(clonedName, telegrafConfig);
    }

    @Override
    @Nonnull
    public Telegraf cloneTelegraf(@Nonnull String clonedName, @Nonnull Telegraf telegraf) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNotNull((Object)telegraf, (String)"TelegrafConfig");
        TelegrafRequest telegrafRequest = this.toTelegrafRequest(telegraf);
        Telegraf created = this.createTelegraf(telegrafRequest);
        created.setName(clonedName);
        this.getLabels(telegraf).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public Telegraf findTelegrafByID(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig ID");
        Call<Telegraf> telegrafConfig = this.service.getTelegrafsIDTelegraf(telegrafID, null, "application/json");
        return (Telegraf)this.execute(telegrafConfig);
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafs() {
        return this.findTelegrafsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findTelegrafsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<Telegraf> findTelegrafsByOrgId(@Nullable String orgID) {
        Call<Telegrafs> configsCall = this.service.getTelegrafs(orgID, null);
        Telegrafs telegrafConfigs = (Telegrafs)this.execute(configsCall);
        LOG.log(Level.FINEST, "findTelegrafs found: {0}", telegrafConfigs);
        return telegrafConfigs.getConfigurations();
    }

    @Override
    @Nonnull
    public String getTOML(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"TelegrafConfig");
        return this.getTOML(telegraf.getId());
    }

    @Override
    @Nonnull
    public String getTOML(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig ID");
        Call<String> telegrafConfig = this.service.getTelegrafsID(telegrafID, null, "application/toml");
        return (String)this.execute(telegrafConfig);
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"TelegrafConfig");
        return this.getMembers(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        Call<ResourceMembers> call = this.service.getTelegrafsIDMembers(telegrafID, null);
        ResourceMembers resourceMembers = (ResourceMembers)this.execute(call);
        LOG.log(Level.FINEST, "findTelegrafConfigMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        Arguments.checkNotNull((Object)member, (String)"member");
        return this.addMember(member.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postTelegrafsIDMembers(telegrafID, user, null);
        return (ResourceMember)this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        Arguments.checkNotNull((Object)member, (String)"member");
        this.deleteMember(member.getId(), telegraf.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        Call<Void> call = this.service.deleteTelegrafsIDMembersID(memberID, telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        return this.getOwners(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        Call<ResourceOwners> call = this.service.getTelegrafsIDOwners(telegrafID, null);
        ResourceOwners resourceMembers = (ResourceOwners)this.execute(call);
        LOG.log(Level.FINEST, "findTelegrafConfigOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        return this.addOwner(owner.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postTelegrafsIDOwners(telegrafID, user, null);
        return (ResourceOwner)this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        this.deleteOwner(owner.getId(), telegraf.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        Call<Void> call = this.service.deleteTelegrafsIDOwnersID(ownerID, telegrafID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        return this.getLabels(telegraf.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)telegrafID, (String)"TelegrafConfig.ID");
        Call<LabelsResponse> call = this.service.getTelegrafsIDLabels(telegrafID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        return this.addLabel(label.getId(), telegraf.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"telegrafConfigID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postTelegrafsIDLabels(telegrafID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)telegraf, (String)"telegrafConfig");
        this.deleteLabel(label.getId(), telegraf.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String telegrafID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)telegrafID, (String)"telegrafConfigID");
        Call<Void> call = this.service.deleteTelegrafsIDLabelsID(telegrafID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private TelegrafRequest toTelegrafRequest(@Nonnull Telegraf telegraf) {
        Arguments.checkNotNull((Object)telegraf, (String)"telegraf");
        TelegrafRequest telegrafRequest = new TelegrafRequest();
        telegrafRequest.setName(telegraf.getName());
        telegrafRequest.setDescription(telegraf.getDescription());
        telegrafRequest.setAgent(telegraf.getAgent());
        telegrafRequest.setOrgID(telegraf.getOrgID());
        if (telegraf.getPlugins() != null) {
            telegraf.getPlugins().forEach(telegrafPlugin -> {
                TelegrafRequestPlugin requestPlugin = new TelegrafRequestPlugin();
                requestPlugin.setType(telegrafPlugin.getType());
                requestPlugin.setName(telegrafPlugin.getName());
                requestPlugin.setConfig(telegrafPlugin.getConfig());
                telegrafRequest.addPluginsItem(requestPlugin);
            });
        }
        return telegrafRequest;
    }
}

