/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client;

import com.influxdb.Arguments;
import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class WriteOptions {
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int DEFAULT_FLUSH_INTERVAL = 1000;
    private static final int DEFAULT_JITTER_INTERVAL = 0;
    private static final int DEFAULT_RETRY_INTERVAL = 1000;
    private static final int DEFAULT_BUFFER_LIMIT = 10000;
    public static final WriteOptions DEFAULTS = WriteOptions.builder().build();
    private final int batchSize;
    private final int flushInterval;
    private final int jitterInterval;
    private final int retryInterval;
    private final int bufferLimit;
    private final Scheduler writeScheduler;
    private final BackpressureOverflowStrategy backpressureStrategy;

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public int getJitterInterval() {
        return this.jitterInterval;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getBufferLimit() {
        return this.bufferLimit;
    }

    @Nonnull
    public Scheduler getWriteScheduler() {
        return this.writeScheduler;
    }

    @Nonnull
    public BackpressureOverflowStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    private WriteOptions(@Nonnull Builder builder) {
        Arguments.checkNotNull((Object)builder, (String)"WriteOptions.Builder");
        this.batchSize = builder.batchSize;
        this.flushInterval = builder.flushInterval;
        this.jitterInterval = builder.jitterInterval;
        this.retryInterval = builder.retryInterval;
        this.bufferLimit = builder.bufferLimit;
        this.writeScheduler = builder.writeScheduler;
        this.backpressureStrategy = builder.backpressureStrategy;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder {
        private int batchSize = 1000;
        private int flushInterval = 1000;
        private int jitterInterval = 0;
        private int retryInterval = 1000;
        private int bufferLimit = 10000;
        private Scheduler writeScheduler = Schedulers.newThread();
        private BackpressureOverflowStrategy backpressureStrategy = BackpressureOverflowStrategy.DROP_OLDEST;

        @Nonnull
        public Builder batchSize(int batchSize) {
            Arguments.checkPositiveNumber((Number)batchSize, (String)"batchSize");
            this.batchSize = batchSize;
            return this;
        }

        @Nonnull
        public Builder flushInterval(int flushInterval) {
            Arguments.checkPositiveNumber((Number)flushInterval, (String)"flushInterval");
            this.flushInterval = flushInterval;
            return this;
        }

        @Nonnull
        public Builder jitterInterval(int jitterInterval) {
            Arguments.checkNotNegativeNumber((Number)jitterInterval, (String)"jitterInterval");
            this.jitterInterval = jitterInterval;
            return this;
        }

        @Nonnull
        public Builder retryInterval(int retryInterval) {
            Arguments.checkPositiveNumber((Number)retryInterval, (String)"retryInterval");
            this.retryInterval = retryInterval;
            return this;
        }

        @Nonnull
        public Builder bufferLimit(int bufferLimit) {
            Arguments.checkNotNegativeNumber((Number)bufferLimit, (String)"bufferLimit");
            this.bufferLimit = bufferLimit;
            return this;
        }

        @Nonnull
        public Builder writeScheduler(@Nonnull Scheduler writeScheduler) {
            Arguments.checkNotNull((Object)writeScheduler, (String)"Write scheduler");
            this.writeScheduler = writeScheduler;
            return this;
        }

        @Nonnull
        public Builder backpressureStrategy(@Nonnull BackpressureOverflowStrategy backpressureStrategy) {
            Arguments.checkNotNull((Object)backpressureStrategy, (String)"Backpressure Overflow Strategy");
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        @Nonnull
        public WriteOptions build() {
            return new WriteOptions(this);
        }
    }
}

