/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write;

import com.influxdb.Arguments;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.PointSettings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Point {
    static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    static final BigInteger MICRO_PER_NANOS = BigInteger.valueOf(1000L);
    static final BigInteger MILLIS_PER_NANOS = BigInteger.valueOf(1000000L);
    static final BigInteger SECONDS_PER_NANOS = BigInteger.valueOf(1000000000L);
    private static final WritePrecision DEFAULT_WRITE_PRECISION = WritePrecision.NS;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    });
    private String name;
    private final Map<String, String> tags = new TreeMap<String, String>();
    private final Map<String, Object> fields = new TreeMap<String, Object>();
    private Number time;
    private WritePrecision precision = DEFAULT_WRITE_PRECISION;

    @Nonnull
    public static Point measurement(@Nonnull String measurementName) {
        Arguments.checkNotNull((Object)measurementName, (String)"measurement");
        Point point = new Point();
        point.name = measurementName;
        return point;
    }

    @Nonnull
    public Point addTag(@Nonnull String key, @Nullable String value) {
        Arguments.checkNotNull((Object)key, (String)"tagName");
        this.tags.put(key, value);
        return this;
    }

    @Nonnull
    public Point addTags(@Nonnull Map<String, String> tagsToAdd) {
        Arguments.checkNotNull(tagsToAdd, (String)"tagsToAdd");
        tagsToAdd.forEach(this::addTag);
        return this;
    }

    @Nonnull
    public Point addField(@Nonnull String field, boolean value) {
        return this.putField(field, value);
    }

    public Point addField(@Nonnull String field, long value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, double value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable Number value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable String value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addFields(@Nonnull Map<String, Object> fieldsToAdd) {
        Arguments.checkNotNull(fieldsToAdd, (String)"fieldsToAdd");
        fieldsToAdd.forEach(this::putField);
        return this;
    }

    @Nonnull
    public Point time(@Nullable Instant time, @Nonnull WritePrecision precision) {
        BigInteger convertedTime;
        if (time == null) {
            return this.time((Long)null, precision);
        }
        BigInteger nanos = BigInteger.valueOf(time.getEpochSecond()).multiply(NANOS_PER_SECOND).add(BigInteger.valueOf(time.getNano()));
        switch (precision) {
            case NS: {
                convertedTime = nanos;
                break;
            }
            case US: {
                convertedTime = nanos.divide(MICRO_PER_NANOS);
                break;
            }
            case MS: {
                convertedTime = nanos.divide(MILLIS_PER_NANOS);
                break;
            }
            case S: {
                convertedTime = nanos.divide(SECONDS_PER_NANOS);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported precision: " + (Object)((Object)precision));
            }
        }
        return this.time(convertedTime, precision);
    }

    @Nonnull
    public Point time(@Nullable Number time, @Nonnull WritePrecision precision) {
        Arguments.checkNotNull((Object)((Object)precision), (String)"precision");
        this.time = time;
        this.precision = precision;
        return this;
    }

    @Nonnull
    public Point time(@Nullable Long time, @Nonnull WritePrecision precision) {
        return this.time((Number)time, precision);
    }

    @Nonnull
    public WritePrecision getPrecision() {
        return this.precision;
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Nonnull
    public String toLineProtocol() {
        return this.toLineProtocol(null);
    }

    @Nonnull
    public String toLineProtocol(@Nullable PointSettings pointSettings) {
        StringBuilder sb = new StringBuilder();
        this.escapeKey(sb, this.name, false);
        this.appendTags(sb, pointSettings);
        boolean appendedFields = this.appendFields(sb);
        if (!appendedFields) {
            return "";
        }
        this.appendTime(sb);
        return sb.toString();
    }

    @Nonnull
    private Point putField(@Nonnull String field, @Nullable Object value) {
        Arguments.checkNonEmpty((String)field, (String)"fieldName");
        this.fields.put(field, value);
        return this;
    }

    private void appendTags(@Nonnull StringBuilder sb, @Nullable PointSettings pointSettings) {
        Map<String, String> defaultTags;
        Set<Map.Entry<String, String>> entries = this.tags.entrySet();
        if (pointSettings != null && !(defaultTags = pointSettings.getDefaultTags()).isEmpty()) {
            entries = Stream.of(this.tags, defaultTags).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                if (v1.isEmpty()) {
                    return v2;
                }
                return v1;
            }, TreeMap::new)).entrySet();
        }
        for (Map.Entry<String, String> tag : entries) {
            String key = tag.getKey();
            String value = tag.getValue();
            if (key.isEmpty() || value.isEmpty()) continue;
            sb.append(',');
            this.escapeKey(sb, key);
            sb.append('=');
            this.escapeKey(sb, value);
        }
        sb.append(' ');
    }

    private boolean appendFields(@Nonnull StringBuilder sb) {
        boolean appended = false;
        for (Map.Entry<String, Object> field : this.fields.entrySet()) {
            Object value = field.getValue();
            if (this.isNotDefined(value)) continue;
            this.escapeKey(sb, field.getKey());
            sb.append('=');
            if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(NUMBER_FORMATTER.get().format(value));
                } else {
                    sb.append(value).append('i');
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                sb.append('\"');
                this.escapeValue(sb, stringValue);
                sb.append('\"');
            } else {
                sb.append(value);
            }
            sb.append(',');
            appended = true;
        }
        int lengthMinusOne = sb.length() - 1;
        if (sb.charAt(lengthMinusOne) == ',') {
            sb.setLength(lengthMinusOne);
        }
        return appended;
    }

    private void appendTime(@Nonnull StringBuilder sb) {
        if (this.time == null) {
            return;
        }
        sb.append(" ");
        if (this.time instanceof BigDecimal) {
            sb.append(((BigDecimal)this.time).toBigInteger());
        } else if (this.time instanceof BigInteger) {
            sb.append(this.time);
        } else {
            sb.append(this.time.longValue());
        }
    }

    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key) {
        this.escapeKey(sb, key, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key, boolean escapeEqual) {
        int i = 0;
        while (true) {
            block9: {
                if (i >= key.length()) {
                    return;
                }
                switch (key.charAt(i)) {
                    case '\n': {
                        sb.append("\\n");
                        break block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break block9;
                    }
                    case ' ': 
                    case ',': {
                        sb.append('\\');
                        break;
                    }
                    case '=': {
                        if (!escapeEqual) break;
                        sb.append('\\');
                    }
                }
                sb.append(key.charAt(i));
            }
            ++i;
        }
    }

    private void escapeValue(@Nonnull StringBuilder sb, @Nonnull String value) {
        for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(value.charAt(i));
        }
    }

    private boolean isNotDefined(Object value) {
        return value == null || value instanceof Double && !Double.isFinite((Double)value) || value instanceof Float && !Float.isFinite(((Float)value).floatValue());
    }
}

