/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.CheckViewProperties;
import com.influxdb.client.domain.GaugeViewProperties;
import com.influxdb.client.domain.HeatmapViewProperties;
import com.influxdb.client.domain.HistogramViewProperties;
import com.influxdb.client.domain.LinePlusSingleStatProperties;
import com.influxdb.client.domain.MarkdownViewProperties;
import com.influxdb.client.domain.ScatterViewProperties;
import com.influxdb.client.domain.SingleStatViewProperties;
import com.influxdb.client.domain.TableViewProperties;
import com.influxdb.client.domain.ViewProperties;
import com.influxdb.client.domain.XYViewProperties;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PkgChart {
    public static final String SERIALIZED_NAME_X_POS = "xPos";
    @SerializedName(value="xPos")
    private Integer xPos;
    public static final String SERIALIZED_NAME_Y_POS = "yPos";
    @SerializedName(value="yPos")
    private Integer yPos;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private Integer width;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    @JsonAdapter(value=PkgChartPropertiesAdapter.class)
    private ViewProperties properties = null;

    public PkgChart xPos(Integer xPos) {
        this.xPos = xPos;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getXPos() {
        return this.xPos;
    }

    public void setXPos(Integer xPos) {
        this.xPos = xPos;
    }

    public PkgChart yPos(Integer yPos) {
        this.yPos = yPos;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getYPos() {
        return this.yPos;
    }

    public void setYPos(Integer yPos) {
        this.yPos = yPos;
    }

    public PkgChart height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PkgChart width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PkgChart properties(ViewProperties properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(value="")
    public ViewProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ViewProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PkgChart pkgChart = (PkgChart)o;
        return Objects.equals(this.xPos, pkgChart.xPos) && Objects.equals(this.yPos, pkgChart.yPos) && Objects.equals(this.height, pkgChart.height) && Objects.equals(this.width, pkgChart.width) && Objects.equals(this.properties, pkgChart.properties);
    }

    public int hashCode() {
        return Objects.hash(this.xPos, this.yPos, this.height, this.width, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PkgChart {\n");
        sb.append("    xPos: ").append(this.toIndentedString(this.xPos)).append("\n");
        sb.append("    yPos: ").append(this.toIndentedString(this.yPos)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public class PkgChartPropertiesAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList("timeFormat", "type", "shape");
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(arg_0 -> ((JsonObject)jsonObject).get(arg_0)).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, (JsonElement)jsonObject, context);
        }

        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"LinePlusSingleStatProperties", "line-plus-single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, LinePlusSingleStatProperties.class);
            }
            if (Arrays.equals(new String[]{"XYViewProperties", "xy", "chronograf-v2"}, types)) {
                return context.deserialize(json, XYViewProperties.class);
            }
            if (Arrays.equals(new String[]{"single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, SingleStatViewProperties.class);
            }
            if (Arrays.equals(new String[]{"histogram", "chronograf-v2"}, types)) {
                return context.deserialize(json, HistogramViewProperties.class);
            }
            if (Arrays.equals(new String[]{"gauge", "chronograf-v2"}, types)) {
                return context.deserialize(json, GaugeViewProperties.class);
            }
            if (Arrays.equals(new String[]{"table", "chronograf-v2"}, types)) {
                return context.deserialize(json, TableViewProperties.class);
            }
            if (Arrays.equals(new String[]{"markdown", "chronograf-v2"}, types)) {
                return context.deserialize(json, MarkdownViewProperties.class);
            }
            if (Arrays.equals(new String[]{"check", "chronograf-v2"}, types)) {
                return context.deserialize(json, CheckViewProperties.class);
            }
            if (Arrays.equals(new String[]{"ScatterViewProperties", "scatter", "chronograf-v2"}, types)) {
                return context.deserialize(json, ScatterViewProperties.class);
            }
            if (Arrays.equals(new String[]{"HeatmapViewProperties", "heatmap", "chronograf-v2"}, types)) {
                return context.deserialize(json, HeatmapViewProperties.class);
            }
            return context.deserialize(json, Object.class);
        }
    }
}

