/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.NotificationRuleBaseLinks;
import com.influxdb.client.domain.PostNotificationRule;
import com.influxdb.client.domain.StatusRule;
import com.influxdb.client.domain.TagRule;
import com.influxdb.client.domain.TaskStatusType;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NotificationRuleBase
extends PostNotificationRule {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ENDPOINT_I_D = "endpointID";
    @SerializedName(value="endpointID")
    private String endpointID;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_OWNER_I_D = "ownerID";
    @SerializedName(value="ownerID")
    private String ownerID;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TaskStatusType status = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SLEEP_UNTIL = "sleepUntil";
    @SerializedName(value="sleepUntil")
    private String sleepUntil;
    public static final String SERIALIZED_NAME_EVERY = "every";
    @SerializedName(value="every")
    private String every;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private String offset;
    public static final String SERIALIZED_NAME_RUNBOOK_LINK = "runbookLink";
    @SerializedName(value="runbookLink")
    private String runbookLink;
    public static final String SERIALIZED_NAME_LIMIT_EVERY = "limitEvery";
    @SerializedName(value="limitEvery")
    private Integer limitEvery;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    private Integer limit;
    public static final String SERIALIZED_NAME_TAG_RULES = "tagRules";
    @SerializedName(value="tagRules")
    private List<TagRule> tagRules = new ArrayList<TagRule>();
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS_RULES = "statusRules";
    @SerializedName(value="statusRules")
    private List<StatusRule> statusRules = new ArrayList<StatusRule>();
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Label> labels = new ArrayList<Label>();
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private NotificationRuleBaseLinks links = null;

    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public NotificationRuleBase endpointID(String endpointID) {
        this.endpointID = endpointID;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    public NotificationRuleBase orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the organization that owns this notification rule.")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    @ApiModelProperty(value="The ID of creator used to create this notification rule.")
    public String getOwnerID() {
        return this.ownerID;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public NotificationRuleBase status(TaskStatusType status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TaskStatusType getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatusType status) {
        this.status = status;
    }

    public NotificationRuleBase name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Human-readable name describing the notification rule.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotificationRuleBase sleepUntil(String sleepUntil) {
        this.sleepUntil = sleepUntil;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSleepUntil() {
        return this.sleepUntil;
    }

    public void setSleepUntil(String sleepUntil) {
        this.sleepUntil = sleepUntil;
    }

    public NotificationRuleBase every(String every) {
        this.every = every;
        return this;
    }

    @ApiModelProperty(value="The notification repetition interval.")
    public String getEvery() {
        return this.every;
    }

    public void setEvery(String every) {
        this.every = every;
    }

    public NotificationRuleBase offset(String offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(value="Duration to delay after the schedule, before executing check.")
    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public NotificationRuleBase runbookLink(String runbookLink) {
        this.runbookLink = runbookLink;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRunbookLink() {
        return this.runbookLink;
    }

    public void setRunbookLink(String runbookLink) {
        this.runbookLink = runbookLink;
    }

    public NotificationRuleBase limitEvery(Integer limitEvery) {
        this.limitEvery = limitEvery;
        return this;
    }

    @ApiModelProperty(value="Don't notify me more than <limit> times every <limitEvery> seconds. If set, limit cannot be empty.")
    public Integer getLimitEvery() {
        return this.limitEvery;
    }

    public void setLimitEvery(Integer limitEvery) {
        this.limitEvery = limitEvery;
    }

    public NotificationRuleBase limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="Don't notify me more than <limit> times every <limitEvery> seconds. If set, limitEvery cannot be empty.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public NotificationRuleBase tagRules(List<TagRule> tagRules) {
        this.tagRules = tagRules;
        return this;
    }

    public NotificationRuleBase addTagRulesItem(TagRule tagRulesItem) {
        this.tagRules.add(tagRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of tag rules the notification rule attempts to match.")
    public List<TagRule> getTagRules() {
        return this.tagRules;
    }

    public void setTagRules(List<TagRule> tagRules) {
        this.tagRules = tagRules;
    }

    public NotificationRuleBase description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="An optional description of the notification rule.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationRuleBase statusRules(List<StatusRule> statusRules) {
        this.statusRules = statusRules;
        return this;
    }

    public NotificationRuleBase addStatusRulesItem(StatusRule statusRulesItem) {
        this.statusRules.add(statusRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of status rules the notification rule attempts to match.")
    public List<StatusRule> getStatusRules() {
        return this.statusRules;
    }

    public void setStatusRules(List<StatusRule> statusRules) {
        this.statusRules = statusRules;
    }

    public NotificationRuleBase labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public NotificationRuleBase addLabelsItem(Label labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Label>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public NotificationRuleBase links(NotificationRuleBaseLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public NotificationRuleBaseLinks getLinks() {
        return this.links;
    }

    public void setLinks(NotificationRuleBaseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRuleBase notificationRuleBase = (NotificationRuleBase)o;
        return Objects.equals(this.id, notificationRuleBase.id) && Objects.equals(this.endpointID, notificationRuleBase.endpointID) && Objects.equals(this.orgID, notificationRuleBase.orgID) && Objects.equals(this.ownerID, notificationRuleBase.ownerID) && Objects.equals(this.createdAt, notificationRuleBase.createdAt) && Objects.equals(this.updatedAt, notificationRuleBase.updatedAt) && Objects.equals((Object)this.status, (Object)notificationRuleBase.status) && Objects.equals(this.name, notificationRuleBase.name) && Objects.equals(this.sleepUntil, notificationRuleBase.sleepUntil) && Objects.equals(this.every, notificationRuleBase.every) && Objects.equals(this.offset, notificationRuleBase.offset) && Objects.equals(this.runbookLink, notificationRuleBase.runbookLink) && Objects.equals(this.limitEvery, notificationRuleBase.limitEvery) && Objects.equals(this.limit, notificationRuleBase.limit) && Objects.equals(this.tagRules, notificationRuleBase.tagRules) && Objects.equals(this.description, notificationRuleBase.description) && Objects.equals(this.statusRules, notificationRuleBase.statusRules) && Objects.equals(this.labels, notificationRuleBase.labels) && Objects.equals(this.links, notificationRuleBase.links) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.endpointID, this.orgID, this.ownerID, this.createdAt, this.updatedAt, this.status, this.name, this.sleepUntil, this.every, this.offset, this.runbookLink, this.limitEvery, this.limit, this.tagRules, this.description, this.statusRules, this.labels, this.links, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationRuleBase {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    endpointID: ").append(this.toIndentedString(this.endpointID)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    ownerID: ").append(this.toIndentedString(this.ownerID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sleepUntil: ").append(this.toIndentedString(this.sleepUntil)).append("\n");
        sb.append("    every: ").append(this.toIndentedString(this.every)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    runbookLink: ").append(this.toIndentedString(this.runbookLink)).append("\n");
        sb.append("    limitEvery: ").append(this.toIndentedString(this.limitEvery)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    tagRules: ").append(this.toIndentedString(this.tagRules)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    statusRules: ").append(this.toIndentedString(this.statusRules)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

