/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.annotations.Column;
import com.influxdb.annotations.Measurement;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import com.influxdb.exceptions.InfluxException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

class MeasurementMapper {
    private static final Logger LOG = Logger.getLogger(MeasurementMapper.class.getName());
    private static final ConcurrentMap<String, ConcurrentMap<String, Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap<String, ConcurrentMap<String, Field>>();

    MeasurementMapper() {
    }

    @Nonnull
    <M> Point toPoint(@Nonnull M measurement, @Nonnull WritePrecision precision) throws InfluxException {
        Arguments.checkNotNull(measurement, (String)"measurement");
        Class<?> measurementType = measurement.getClass();
        this.cacheMeasurementClass(measurementType);
        if (measurementType.getAnnotation(Measurement.class) == null) {
            String message = String.format("Measurement type '%s' does not have a @Measurement annotation.", measurementType);
            throw new InfluxException(message);
        }
        Point point = Point.measurement(this.getMeasurementName(measurementType));
        ((ConcurrentMap)CLASS_FIELD_CACHE.get(measurementType.getName())).forEach((name, field) -> {
            Object value;
            Column column = field.getAnnotation(Column.class);
            try {
                field.setAccessible(true);
                value = field.get(measurement);
            }
            catch (IllegalAccessException e) {
                throw new InfluxException((Throwable)e);
            }
            if (value == null) {
                Object[] params = new Object[]{field.getName(), measurement};
                LOG.log(Level.FINEST, "Field {0} of {1} has null value", params);
                return;
            }
            Class<?> fieldType = field.getType();
            if (column.tag()) {
                point.addTag((String)name, value.toString());
            } else if (column.timestamp()) {
                Instant instant = (Instant)value;
                point.time(instant, precision);
            } else if (this.isNumber(fieldType)) {
                point.addField((String)name, (Number)value);
            } else if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                point.addField((String)name, (Boolean)value);
            } else if (String.class.isAssignableFrom(fieldType)) {
                point.addField((String)name, (String)value);
            } else {
                point.addField((String)name, value.toString());
            }
        });
        LOG.log(Level.FINEST, "Mapped measurement: {0} to Point: {1}", new Object[]{measurement, point});
        return point;
    }

    @Nonnull
    private String getMeasurementName(@Nonnull Class<?> measurementType) {
        return measurementType.getAnnotation(Measurement.class).name();
    }

    private boolean isNumber(@Nonnull Class<?> fieldType) {
        return Number.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType);
    }

    private void cacheMeasurementClass(Class<?> ... measurementTypes) {
        for (Class<?> measurementType : measurementTypes) {
            if (CLASS_FIELD_CACHE.containsKey(measurementType.getName())) continue;
            ConcurrentHashMap<String, Field> initialMap = new ConcurrentHashMap<String, Field>();
            ConcurrentHashMap<String, Field> influxColumnAndFieldMap = CLASS_FIELD_CACHE.putIfAbsent(measurementType.getName(), initialMap);
            if (influxColumnAndFieldMap == null) {
                influxColumnAndFieldMap = initialMap;
            }
            for (Field field : measurementType.getDeclaredFields()) {
                Column colAnnotation = field.getAnnotation(Column.class);
                if (colAnnotation == null) continue;
                String name = colAnnotation.name();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                influxColumnAndFieldMap.put(name, field);
            }
        }
    }
}

