/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.GreaterThreshold;
import com.influxdb.client.domain.LesserThreshold;
import com.influxdb.client.domain.RangeThreshold;
import com.influxdb.client.domain.Threshold;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ThresholdCheck
extends Check {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.THRESHOLD;
    public static final String SERIALIZED_NAME_THRESHOLDS = "thresholds";
    @SerializedName(value="thresholds")
    @JsonAdapter(value=ThresholdCheckThresholdsAdapter.class)
    private List<Threshold> thresholds = new ArrayList<Threshold>();

    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    public ThresholdCheck thresholds(List<Threshold> thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public ThresholdCheck addThresholdsItem(Threshold thresholdsItem) {
        if (this.thresholds == null) {
            this.thresholds = new ArrayList<Threshold>();
        }
        this.thresholds.add(thresholdsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Threshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<Threshold> thresholds) {
        this.thresholds = thresholds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdCheck thresholdCheck = (ThresholdCheck)o;
        return Objects.equals((Object)this.type, (Object)thresholdCheck.type) && Objects.equals(this.thresholds, thresholdCheck.thresholds) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.thresholds, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThresholdCheck {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public class ThresholdCheckThresholdsAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(ThresholdCheck.SERIALIZED_NAME_TYPE);
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement arrayItem : json.getAsJsonArray()) {
                JsonObject jsonObject = arrayItem.getAsJsonObject();
                String[] types = (String[])discriminator.stream().map(d -> jsonObject.get(d).getAsString()).toArray(String[]::new);
                results.add(this.deserialize(types, (JsonElement)jsonObject, context));
            }
            return results;
        }

        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"greater"}, types)) {
                return context.deserialize(json, GreaterThreshold.class);
            }
            if (Arrays.equals(new String[]{"lesser"}, types)) {
                return context.deserialize(json, LesserThreshold.class);
            }
            if (Arrays.equals(new String[]{"range"}, types)) {
                return context.deserialize(json, RangeThreshold.class);
            }
            return context.deserialize(json, Object.class);
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        THRESHOLD("threshold");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

