/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.Buckets;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.PostBucketRequest;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface BucketsService {
    @DELETE(value="api/v2/buckets/{bucketID}")
    public Call<Void> deleteBucketsID(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/buckets/{bucketID}/labels/{labelID}")
    public Call<Void> deleteBucketsIDLabelsID(@Path(value="bucketID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/buckets/{bucketID}/members/{userID}")
    public Call<Void> deleteBucketsIDMembersID(@Path(value="userID") String var1, @Path(value="bucketID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/buckets/{bucketID}/owners/{userID}")
    public Call<Void> deleteBucketsIDOwnersID(@Path(value="userID") String var1, @Path(value="bucketID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/buckets")
    public Call<Buckets> getBuckets(@Header(value="Zap-Trace-Span") String var1, @Query(value="offset") Integer var2, @Query(value="limit") Integer var3, @Query(value="org") String var4, @Query(value="orgID") String var5, @Query(value="name") String var6);

    @GET(value="api/v2/buckets/{bucketID}")
    public Call<Bucket> getBucketsID(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/buckets/{bucketID}/labels")
    public Call<LabelsResponse> getBucketsIDLabels(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/buckets/{bucketID}/members")
    public Call<ResourceMembers> getBucketsIDMembers(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/buckets/{bucketID}/owners")
    public Call<ResourceOwners> getBucketsIDOwners(@Path(value="bucketID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/sources/{sourceID}/buckets")
    public Call<Buckets> getSourcesIDBuckets(@Path(value="sourceID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="org") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/buckets/{bucketID}")
    public Call<Bucket> patchBucketsID(@Path(value="bucketID") String var1, @Body Bucket var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets")
    public Call<Bucket> postBuckets(@Body PostBucketRequest var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets/{bucketID}/labels")
    public Call<LabelResponse> postBucketsIDLabels(@Path(value="bucketID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets/{bucketID}/members")
    public Call<ResourceMember> postBucketsIDMembers(@Path(value="bucketID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/buckets/{bucketID}/owners")
    public Call<ResourceOwner> postBucketsIDOwners(@Path(value="bucketID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);
}

