/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.ViewProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HeatmapViewProperties
extends ViewProperties {
    public static final String SERIALIZED_NAME_TIME_FORMAT = "timeFormat";
    @SerializedName(value="timeFormat")
    private String timeFormat;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.HEATMAP;
    public static final String SERIALIZED_NAME_QUERIES = "queries";
    @SerializedName(value="queries")
    private List<DashboardQuery> queries = new ArrayList<DashboardQuery>();
    public static final String SERIALIZED_NAME_COLORS = "colors";
    @SerializedName(value="colors")
    private List<String> colors = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SHAPE = "shape";
    @SerializedName(value="shape")
    private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;
    public static final String SERIALIZED_NAME_NOTE = "note";
    @SerializedName(value="note")
    private String note;
    public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
    @SerializedName(value="showNoteWhenEmpty")
    private Boolean showNoteWhenEmpty;
    public static final String SERIALIZED_NAME_X_COLUMN = "xColumn";
    @SerializedName(value="xColumn")
    private String xColumn;
    public static final String SERIALIZED_NAME_Y_COLUMN = "yColumn";
    @SerializedName(value="yColumn")
    private String yColumn;
    public static final String SERIALIZED_NAME_X_DOMAIN = "xDomain";
    @SerializedName(value="xDomain")
    private List<BigDecimal> xDomain = new ArrayList<BigDecimal>();
    public static final String SERIALIZED_NAME_Y_DOMAIN = "yDomain";
    @SerializedName(value="yDomain")
    private List<BigDecimal> yDomain = new ArrayList<BigDecimal>();
    public static final String SERIALIZED_NAME_X_AXIS_LABEL = "xAxisLabel";
    @SerializedName(value="xAxisLabel")
    private String xAxisLabel;
    public static final String SERIALIZED_NAME_Y_AXIS_LABEL = "yAxisLabel";
    @SerializedName(value="yAxisLabel")
    private String yAxisLabel;
    public static final String SERIALIZED_NAME_X_PREFIX = "xPrefix";
    @SerializedName(value="xPrefix")
    private String xPrefix;
    public static final String SERIALIZED_NAME_X_SUFFIX = "xSuffix";
    @SerializedName(value="xSuffix")
    private String xSuffix;
    public static final String SERIALIZED_NAME_Y_PREFIX = "yPrefix";
    @SerializedName(value="yPrefix")
    private String yPrefix;
    public static final String SERIALIZED_NAME_Y_SUFFIX = "ySuffix";
    @SerializedName(value="ySuffix")
    private String ySuffix;
    public static final String SERIALIZED_NAME_BIN_SIZE = "binSize";
    @SerializedName(value="binSize")
    private BigDecimal binSize;

    public HeatmapViewProperties timeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public HeatmapViewProperties queries(List<DashboardQuery> queries) {
        this.queries = queries;
        return this;
    }

    public HeatmapViewProperties addQueriesItem(DashboardQuery queriesItem) {
        this.queries.add(queriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<DashboardQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DashboardQuery> queries) {
        this.queries = queries;
    }

    public HeatmapViewProperties colors(List<String> colors) {
        this.colors = colors;
        return this;
    }

    public HeatmapViewProperties addColorsItem(String colorsItem) {
        this.colors.add(colorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Colors define color encoding of data into a visualization")
    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    @ApiModelProperty(required=true, value="")
    public ShapeEnum getShape() {
        return this.shape;
    }

    public HeatmapViewProperties note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public HeatmapViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, will display note when empty")
    public Boolean getShowNoteWhenEmpty() {
        return this.showNoteWhenEmpty;
    }

    public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
        this.showNoteWhenEmpty = showNoteWhenEmpty;
    }

    public HeatmapViewProperties xColumn(String xColumn) {
        this.xColumn = xColumn;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXColumn() {
        return this.xColumn;
    }

    public void setXColumn(String xColumn) {
        this.xColumn = xColumn;
    }

    public HeatmapViewProperties yColumn(String yColumn) {
        this.yColumn = yColumn;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getYColumn() {
        return this.yColumn;
    }

    public void setYColumn(String yColumn) {
        this.yColumn = yColumn;
    }

    public HeatmapViewProperties xDomain(List<BigDecimal> xDomain) {
        this.xDomain = xDomain;
        return this;
    }

    public HeatmapViewProperties addXDomainItem(BigDecimal xDomainItem) {
        this.xDomain.add(xDomainItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<BigDecimal> getXDomain() {
        return this.xDomain;
    }

    public void setXDomain(List<BigDecimal> xDomain) {
        this.xDomain = xDomain;
    }

    public HeatmapViewProperties yDomain(List<BigDecimal> yDomain) {
        this.yDomain = yDomain;
        return this;
    }

    public HeatmapViewProperties addYDomainItem(BigDecimal yDomainItem) {
        this.yDomain.add(yDomainItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<BigDecimal> getYDomain() {
        return this.yDomain;
    }

    public void setYDomain(List<BigDecimal> yDomain) {
        this.yDomain = yDomain;
    }

    public HeatmapViewProperties xAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public HeatmapViewProperties yAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public HeatmapViewProperties xPrefix(String xPrefix) {
        this.xPrefix = xPrefix;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXPrefix() {
        return this.xPrefix;
    }

    public void setXPrefix(String xPrefix) {
        this.xPrefix = xPrefix;
    }

    public HeatmapViewProperties xSuffix(String xSuffix) {
        this.xSuffix = xSuffix;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getXSuffix() {
        return this.xSuffix;
    }

    public void setXSuffix(String xSuffix) {
        this.xSuffix = xSuffix;
    }

    public HeatmapViewProperties yPrefix(String yPrefix) {
        this.yPrefix = yPrefix;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getYPrefix() {
        return this.yPrefix;
    }

    public void setYPrefix(String yPrefix) {
        this.yPrefix = yPrefix;
    }

    public HeatmapViewProperties ySuffix(String ySuffix) {
        this.ySuffix = ySuffix;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getYSuffix() {
        return this.ySuffix;
    }

    public void setYSuffix(String ySuffix) {
        this.ySuffix = ySuffix;
    }

    public HeatmapViewProperties binSize(BigDecimal binSize) {
        this.binSize = binSize;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BigDecimal getBinSize() {
        return this.binSize;
    }

    public void setBinSize(BigDecimal binSize) {
        this.binSize = binSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeatmapViewProperties heatmapViewProperties = (HeatmapViewProperties)o;
        return Objects.equals(this.timeFormat, heatmapViewProperties.timeFormat) && Objects.equals((Object)this.type, (Object)heatmapViewProperties.type) && Objects.equals(this.queries, heatmapViewProperties.queries) && Objects.equals(this.colors, heatmapViewProperties.colors) && Objects.equals((Object)this.shape, (Object)heatmapViewProperties.shape) && Objects.equals(this.note, heatmapViewProperties.note) && Objects.equals(this.showNoteWhenEmpty, heatmapViewProperties.showNoteWhenEmpty) && Objects.equals(this.xColumn, heatmapViewProperties.xColumn) && Objects.equals(this.yColumn, heatmapViewProperties.yColumn) && Objects.equals(this.xDomain, heatmapViewProperties.xDomain) && Objects.equals(this.yDomain, heatmapViewProperties.yDomain) && Objects.equals(this.xAxisLabel, heatmapViewProperties.xAxisLabel) && Objects.equals(this.yAxisLabel, heatmapViewProperties.yAxisLabel) && Objects.equals(this.xPrefix, heatmapViewProperties.xPrefix) && Objects.equals(this.xSuffix, heatmapViewProperties.xSuffix) && Objects.equals(this.yPrefix, heatmapViewProperties.yPrefix) && Objects.equals(this.ySuffix, heatmapViewProperties.ySuffix) && Objects.equals(this.binSize, heatmapViewProperties.binSize) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.timeFormat, this.type, this.queries, this.colors, this.shape, this.note, this.showNoteWhenEmpty, this.xColumn, this.yColumn, this.xDomain, this.yDomain, this.xAxisLabel, this.yAxisLabel, this.xPrefix, this.xSuffix, this.yPrefix, this.ySuffix, this.binSize, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeatmapViewProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    timeFormat: ").append(this.toIndentedString(this.timeFormat)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    colors: ").append(this.toIndentedString(this.colors)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    showNoteWhenEmpty: ").append(this.toIndentedString(this.showNoteWhenEmpty)).append("\n");
        sb.append("    xColumn: ").append(this.toIndentedString(this.xColumn)).append("\n");
        sb.append("    yColumn: ").append(this.toIndentedString(this.yColumn)).append("\n");
        sb.append("    xDomain: ").append(this.toIndentedString(this.xDomain)).append("\n");
        sb.append("    yDomain: ").append(this.toIndentedString(this.yDomain)).append("\n");
        sb.append("    xAxisLabel: ").append(this.toIndentedString(this.xAxisLabel)).append("\n");
        sb.append("    yAxisLabel: ").append(this.toIndentedString(this.yAxisLabel)).append("\n");
        sb.append("    xPrefix: ").append(this.toIndentedString(this.xPrefix)).append("\n");
        sb.append("    xSuffix: ").append(this.toIndentedString(this.xSuffix)).append("\n");
        sb.append("    yPrefix: ").append(this.toIndentedString(this.yPrefix)).append("\n");
        sb.append("    ySuffix: ").append(this.toIndentedString(this.ySuffix)).append("\n");
        sb.append("    binSize: ").append(this.toIndentedString(this.binSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShapeEnum {
        CHRONOGRAF_V2("chronograf-v2");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShapeEnum fromValue(String text) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShapeEnum> {
            public void write(JsonWriter jsonWriter, ShapeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShapeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShapeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        HEATMAP("heatmap");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

