/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteBlockingClient;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.service.WriteService;
import com.influxdb.client.write.Point;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class WriteApiBlockingImpl
extends AbstractWriteBlockingClient
implements WriteApiBlocking {
    WriteApiBlockingImpl(@Nonnull WriteService service, @Nonnull InfluxDBClientOptions options) {
        super(service, options);
    }

    @Override
    public void writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public void writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        if (record == null) {
            return;
        }
        this.write(bucket, org, precision, new AbstractWriteClient.BatchWriteDataRecord(record));
    }

    @Override
    public void writeRecords(@Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public void writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(records, (String)"records");
        this.write(bucket, org, precision, records.stream().map(AbstractWriteClient.BatchWriteDataRecord::new));
    }

    @Override
    public void writePoint(@Nullable Point point) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoint(this.options.getBucket(), this.options.getOrg(), point);
    }

    @Override
    public void writePoint(@Nonnull String bucket, @Nonnull String org, @Nullable Point point) {
        if (point == null) {
            return;
        }
        this.writePoints(bucket, org, Collections.singletonList(point));
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoints(this.options.getBucket(), this.options.getOrg(), points);
    }

    @Override
    public void writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull List<Point> points) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull(points, (String)"points");
        points.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Point::getPrecision, LinkedHashMap::new, Collectors.toList())).forEach((precision, grouped) -> this.write(bucket, org, (WritePrecision)((Object)precision), grouped.stream().map(it -> new AbstractWriteClient.BatchWriteDataPoint((Point)it, this.options))));
    }

    @Override
    public <M> void writeMeasurement(@Nonnull WritePrecision precision, @Nullable M measurement) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable M measurement) {
        if (measurement == null) {
            return;
        }
        this.writeMeasurements(bucket, org, precision, Collections.singletonList(measurement));
    }

    @Override
    public <M> void writeMeasurements(@Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(measurements, (String)"records");
        this.write(bucket, org, precision, measurements.stream().map(it -> this.toMeasurementBatch(it, precision)));
    }

    private void write(@Nonnull String bucket, @Nonnull String organization, @Nonnull WritePrecision precision, @Nonnull AbstractWriteClient.BatchWriteData data) {
        this.write(bucket, organization, precision, Stream.of(data));
    }
}

