/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.BadStatement;
import com.influxdb.client.domain.BuiltinStatement;
import com.influxdb.client.domain.ExpressionStatement;
import com.influxdb.client.domain.MemberAssignment;
import com.influxdb.client.domain.Node;
import com.influxdb.client.domain.OptionStatement;
import com.influxdb.client.domain.ReturnStatement;
import com.influxdb.client.domain.Statement;
import com.influxdb.client.domain.TestStatement;
import com.influxdb.client.domain.VariableAssignment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A set of statements")
public class Block
extends Node {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    @JsonAdapter(value=BlockBodyAdapter.class)
    private List<Statement> body = new ArrayList<Statement>();

    public Block type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of AST node")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Block body(List<Statement> body) {
        this.body = body;
        return this;
    }

    public Block addBodyItem(Statement bodyItem) {
        if (this.body == null) {
            this.body = new ArrayList<Statement>();
        }
        this.body.add(bodyItem);
        return this;
    }

    @ApiModelProperty(value="Block body")
    public List<Statement> getBody() {
        return this.body;
    }

    public void setBody(List<Statement> body) {
        this.body = body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return Objects.equals(this.type, block.type) && Objects.equals(this.body, block.body) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.body, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Block {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public class BlockBodyAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList(Block.SERIALIZED_NAME_TYPE);
            ArrayList<Object> results = new ArrayList<Object>();
            for (JsonElement arrayItem : json.getAsJsonArray()) {
                JsonObject jsonObject = arrayItem.getAsJsonObject();
                String[] types = (String[])discriminator.stream().map(arg_0 -> ((JsonObject)jsonObject).get(arg_0)).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
                results.add(this.deserialize(types, (JsonElement)jsonObject, context));
            }
            return results;
        }

        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"BadStatement"}, types)) {
                return context.deserialize(json, BadStatement.class);
            }
            if (Arrays.equals(new String[]{"VariableAssignment"}, types)) {
                return context.deserialize(json, VariableAssignment.class);
            }
            if (Arrays.equals(new String[]{"MemberAssignment"}, types)) {
                return context.deserialize(json, MemberAssignment.class);
            }
            if (Arrays.equals(new String[]{"ExpressionStatement"}, types)) {
                return context.deserialize(json, ExpressionStatement.class);
            }
            if (Arrays.equals(new String[]{"ReturnStatement"}, types)) {
                return context.deserialize(json, ReturnStatement.class);
            }
            if (Arrays.equals(new String[]{"OptionStatement"}, types)) {
                return context.deserialize(json, OptionStatement.class);
            }
            if (Arrays.equals(new String[]{"BuiltinStatement"}, types)) {
                return context.deserialize(json, BuiltinStatement.class);
            }
            if (Arrays.equals(new String[]{"TestStatement"}, types)) {
                return context.deserialize(json, TestStatement.class);
            }
            return context.deserialize(json, Object.class);
        }
    }
}

