/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="The delete predicate request.")
public class DeletePredicateRequest {
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private OffsetDateTime start;
    public static final String SERIALIZED_NAME_STOP = "stop";
    @SerializedName(value="stop")
    private OffsetDateTime stop;
    public static final String SERIALIZED_NAME_PREDICATE = "predicate";
    @SerializedName(value="predicate")
    private String predicate;

    public DeletePredicateRequest start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(required=true, value="RFC3339Nano")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public DeletePredicateRequest stop(OffsetDateTime stop) {
        this.stop = stop;
        return this;
    }

    @ApiModelProperty(required=true, value="RFC3339Nano")
    public OffsetDateTime getStop() {
        return this.stop;
    }

    public void setStop(OffsetDateTime stop) {
        this.stop = stop;
    }

    public DeletePredicateRequest predicate(String predicate) {
        this.predicate = predicate;
        return this;
    }

    @ApiModelProperty(example="tag1=\"value1\" and (tag2=\"value2\" and tag3!=\"value3\")", value="InfluxQL-like delete statement")
    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePredicateRequest deletePredicateRequest = (DeletePredicateRequest)o;
        return Objects.equals(this.start, deletePredicateRequest.start) && Objects.equals(this.stop, deletePredicateRequest.stop) && Objects.equals(this.predicate, deletePredicateRequest.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.stop, this.predicate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeletePredicateRequest {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    stop: ").append(this.toIndentedString(this.stop)).append("\n");
        sb.append("    predicate: ").append(this.toIndentedString(this.predicate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

