/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Field {
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_ARGS = "args";
    @SerializedName(value="args")
    private List<Field> args = new ArrayList<Field>();

    public Field value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="value is the value of the field.  Meaning of the value is implied by the `type` key")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Field type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="`type` describes the field type. `func` is a function. `field` is a field reference.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Field alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="Alias overrides the field name in the returned response.  Applies only if type is `func`")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Field args(List<Field> args) {
        this.args = args;
        return this;
    }

    public Field addArgsItem(Field argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<Field>();
        }
        this.args.add(argsItem);
        return this;
    }

    @ApiModelProperty(value="Args are the arguments to the function")
    public List<Field> getArgs() {
        return this.args;
    }

    public void setArgs(List<Field> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.value, field.value) && Objects.equals((Object)this.type, (Object)field.type) && Objects.equals(this.alias, field.alias) && Objects.equals(this.args, field.args);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type, this.alias, this.args});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Field {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FUNC("func"),
        FIELD("field"),
        INTEGER("integer"),
        NUMBER("number"),
        REGEX("regex"),
        WILDCARD("wildcard");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

