/*
 * Influx OSS API Service
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.DashboardColor;
import com.influxdb.client.domain.DashboardQuery;
import com.influxdb.client.domain.DecimalPlaces;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GaugeViewProperties
 */

public class GaugeViewProperties extends ViewProperties {
  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    GAUGE("gauge");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.GAUGE;

  public static final String SERIALIZED_NAME_QUERIES = "queries";
  @SerializedName(SERIALIZED_NAME_QUERIES)
  private List<DashboardQuery> queries = new ArrayList<>();

  public static final String SERIALIZED_NAME_COLORS = "colors";
  @SerializedName(SERIALIZED_NAME_COLORS)
  private List<DashboardColor> colors = new ArrayList<>();

  /**
   * Gets or Sets shape
   */
  @JsonAdapter(ShapeEnum.Adapter.class)
  public enum ShapeEnum {
    CHRONOGRAF_V2("chronograf-v2");

    private String value;

    ShapeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ShapeEnum fromValue(String text) {
      for (ShapeEnum b : ShapeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ShapeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ShapeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ShapeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return ShapeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_SHAPE = "shape";
  @SerializedName(SERIALIZED_NAME_SHAPE)
  private ShapeEnum shape = ShapeEnum.CHRONOGRAF_V2;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY = "showNoteWhenEmpty";
  @SerializedName(SERIALIZED_NAME_SHOW_NOTE_WHEN_EMPTY)
  private Boolean showNoteWhenEmpty;

  public static final String SERIALIZED_NAME_PREFIX = "prefix";
  @SerializedName(SERIALIZED_NAME_PREFIX)
  private String prefix;

  public static final String SERIALIZED_NAME_TICK_PREFIX = "tickPrefix";
  @SerializedName(SERIALIZED_NAME_TICK_PREFIX)
  private String tickPrefix;

  public static final String SERIALIZED_NAME_SUFFIX = "suffix";
  @SerializedName(SERIALIZED_NAME_SUFFIX)
  private String suffix;

  public static final String SERIALIZED_NAME_TICK_SUFFIX = "tickSuffix";
  @SerializedName(SERIALIZED_NAME_TICK_SUFFIX)
  private String tickSuffix;

  public static final String SERIALIZED_NAME_DECIMAL_PLACES = "decimalPlaces";
  @SerializedName(SERIALIZED_NAME_DECIMAL_PLACES)
  private DecimalPlaces decimalPlaces = null;

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  public TypeEnum getType() {
    return type;
  }

  public GaugeViewProperties queries(List<DashboardQuery> queries) {
    this.queries = queries;
    return this;
  }

  public GaugeViewProperties addQueriesItem(DashboardQuery queriesItem) {
    this.queries.add(queriesItem);
    return this;
  }

   /**
   * Get queries
   * @return queries
  **/
  @ApiModelProperty(required = true, value = "")
  public List<DashboardQuery> getQueries() {
    return queries;
  }

  public void setQueries(List<DashboardQuery> queries) {
    this.queries = queries;
  }

  public GaugeViewProperties colors(List<DashboardColor> colors) {
    this.colors = colors;
    return this;
  }

  public GaugeViewProperties addColorsItem(DashboardColor colorsItem) {
    this.colors.add(colorsItem);
    return this;
  }

   /**
   * Colors define color encoding of data into a visualization
   * @return colors
  **/
  @ApiModelProperty(required = true, value = "Colors define color encoding of data into a visualization")
  public List<DashboardColor> getColors() {
    return colors;
  }

  public void setColors(List<DashboardColor> colors) {
    this.colors = colors;
  }

   /**
   * Get shape
   * @return shape
  **/
  @ApiModelProperty(required = true, value = "")
  public ShapeEnum getShape() {
    return shape;
  }

  public GaugeViewProperties note(String note) {
    this.note = note;
    return this;
  }

   /**
   * Get note
   * @return note
  **/
  @ApiModelProperty(required = true, value = "")
  public String getNote() {
    return note;
  }

  public void setNote(String note) {
    this.note = note;
  }

  public GaugeViewProperties showNoteWhenEmpty(Boolean showNoteWhenEmpty) {
    this.showNoteWhenEmpty = showNoteWhenEmpty;
    return this;
  }

   /**
   * If true, will display note when empty
   * @return showNoteWhenEmpty
  **/
  @ApiModelProperty(required = true, value = "If true, will display note when empty")
  public Boolean getShowNoteWhenEmpty() {
    return showNoteWhenEmpty;
  }

  public void setShowNoteWhenEmpty(Boolean showNoteWhenEmpty) {
    this.showNoteWhenEmpty = showNoteWhenEmpty;
  }

  public GaugeViewProperties prefix(String prefix) {
    this.prefix = prefix;
    return this;
  }

   /**
   * Get prefix
   * @return prefix
  **/
  @ApiModelProperty(required = true, value = "")
  public String getPrefix() {
    return prefix;
  }

  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }

  public GaugeViewProperties tickPrefix(String tickPrefix) {
    this.tickPrefix = tickPrefix;
    return this;
  }

   /**
   * Get tickPrefix
   * @return tickPrefix
  **/
  @ApiModelProperty(required = true, value = "")
  public String getTickPrefix() {
    return tickPrefix;
  }

  public void setTickPrefix(String tickPrefix) {
    this.tickPrefix = tickPrefix;
  }

  public GaugeViewProperties suffix(String suffix) {
    this.suffix = suffix;
    return this;
  }

   /**
   * Get suffix
   * @return suffix
  **/
  @ApiModelProperty(required = true, value = "")
  public String getSuffix() {
    return suffix;
  }

  public void setSuffix(String suffix) {
    this.suffix = suffix;
  }

  public GaugeViewProperties tickSuffix(String tickSuffix) {
    this.tickSuffix = tickSuffix;
    return this;
  }

   /**
   * Get tickSuffix
   * @return tickSuffix
  **/
  @ApiModelProperty(required = true, value = "")
  public String getTickSuffix() {
    return tickSuffix;
  }

  public void setTickSuffix(String tickSuffix) {
    this.tickSuffix = tickSuffix;
  }

  public GaugeViewProperties decimalPlaces(DecimalPlaces decimalPlaces) {
    this.decimalPlaces = decimalPlaces;
    return this;
  }

   /**
   * Get decimalPlaces
   * @return decimalPlaces
  **/
  @ApiModelProperty(required = true, value = "")
  public DecimalPlaces getDecimalPlaces() {
    return decimalPlaces;
  }

  public void setDecimalPlaces(DecimalPlaces decimalPlaces) {
    this.decimalPlaces = decimalPlaces;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GaugeViewProperties gaugeViewProperties = (GaugeViewProperties) o;
    return Objects.equals(this.type, gaugeViewProperties.type) &&
        Objects.equals(this.queries, gaugeViewProperties.queries) &&
        Objects.equals(this.colors, gaugeViewProperties.colors) &&
        Objects.equals(this.shape, gaugeViewProperties.shape) &&
        Objects.equals(this.note, gaugeViewProperties.note) &&
        Objects.equals(this.showNoteWhenEmpty, gaugeViewProperties.showNoteWhenEmpty) &&
        Objects.equals(this.prefix, gaugeViewProperties.prefix) &&
        Objects.equals(this.tickPrefix, gaugeViewProperties.tickPrefix) &&
        Objects.equals(this.suffix, gaugeViewProperties.suffix) &&
        Objects.equals(this.tickSuffix, gaugeViewProperties.tickSuffix) &&
        Objects.equals(this.decimalPlaces, gaugeViewProperties.decimalPlaces) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, queries, colors, shape, note, showNoteWhenEmpty, prefix, tickPrefix, suffix, tickSuffix, decimalPlaces, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GaugeViewProperties {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    queries: ").append(toIndentedString(queries)).append("\n");
    sb.append("    colors: ").append(toIndentedString(colors)).append("\n");
    sb.append("    shape: ").append(toIndentedString(shape)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    showNoteWhenEmpty: ").append(toIndentedString(showNoteWhenEmpty)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("    tickPrefix: ").append(toIndentedString(tickPrefix)).append("\n");
    sb.append("    suffix: ").append(toIndentedString(suffix)).append("\n");
    sb.append("    tickSuffix: ").append(toIndentedString(tickSuffix)).append("\n");
    sb.append("    decimalPlaces: ").append(toIndentedString(decimalPlaces)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

