/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * TelegramNotificationRuleBase
 */

public class TelegramNotificationRuleBase extends NotificationRule {
  /**
   * The discriminator between other types of notification rules is \&quot;telegram\&quot;.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    TELEGRAM("telegram");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.TELEGRAM;

  public static final String SERIALIZED_NAME_MESSAGE_TEMPLATE = "messageTemplate";
  @SerializedName(SERIALIZED_NAME_MESSAGE_TEMPLATE)
  private String messageTemplate;

  /**
   * Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \&quot;MarkdownV2\&quot; .
   */
  @JsonAdapter(ParseModeEnum.Adapter.class)
  public enum ParseModeEnum {
    MARKDOWNV2("MarkdownV2"),
    
    HTML("HTML"),
    
    MARKDOWN("Markdown");

    private String value;

    ParseModeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ParseModeEnum fromValue(String text) {
      for (ParseModeEnum b : ParseModeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ParseModeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ParseModeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ParseModeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return ParseModeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_PARSE_MODE = "parseMode";
  @SerializedName(SERIALIZED_NAME_PARSE_MODE)
  private ParseModeEnum parseMode;

  public static final String SERIALIZED_NAME_DISABLE_WEB_PAGE_PREVIEW = "disableWebPagePreview";
  @SerializedName(SERIALIZED_NAME_DISABLE_WEB_PAGE_PREVIEW)
  private Boolean disableWebPagePreview;

   /**
   * The discriminator between other types of notification rules is \&quot;telegram\&quot;.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The discriminator between other types of notification rules is \"telegram\".")
  public TypeEnum getType() {
    return type;
  }

  public TelegramNotificationRuleBase messageTemplate(String messageTemplate) {
    this.messageTemplate = messageTemplate;
    return this;
  }

   /**
   * The message template as a flux interpolated string.
   * @return messageTemplate
  **/
  @ApiModelProperty(required = true, value = "The message template as a flux interpolated string.")
  public String getMessageTemplate() {
    return messageTemplate;
  }

  public void setMessageTemplate(String messageTemplate) {
    this.messageTemplate = messageTemplate;
  }

  public TelegramNotificationRuleBase parseMode(ParseModeEnum parseMode) {
    this.parseMode = parseMode;
    return this;
  }

   /**
   * Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \&quot;MarkdownV2\&quot; .
   * @return parseMode
  **/
  @ApiModelProperty(value = "Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \"MarkdownV2\" .")
  public ParseModeEnum getParseMode() {
    return parseMode;
  }

  public void setParseMode(ParseModeEnum parseMode) {
    this.parseMode = parseMode;
  }

  public TelegramNotificationRuleBase disableWebPagePreview(Boolean disableWebPagePreview) {
    this.disableWebPagePreview = disableWebPagePreview;
    return this;
  }

   /**
   * Disables preview of web links in the sent messages when \&quot;true\&quot;. Defaults to \&quot;false\&quot; .
   * @return disableWebPagePreview
  **/
  @ApiModelProperty(value = "Disables preview of web links in the sent messages when \"true\". Defaults to \"false\" .")
  public Boolean getDisableWebPagePreview() {
    return disableWebPagePreview;
  }

  public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
    this.disableWebPagePreview = disableWebPagePreview;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelegramNotificationRuleBase telegramNotificationRuleBase = (TelegramNotificationRuleBase) o;
    return Objects.equals(this.type, telegramNotificationRuleBase.type) &&
        Objects.equals(this.messageTemplate, telegramNotificationRuleBase.messageTemplate) &&
        Objects.equals(this.parseMode, telegramNotificationRuleBase.parseMode) &&
        Objects.equals(this.disableWebPagePreview, telegramNotificationRuleBase.disableWebPagePreview) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, messageTemplate, parseMode, disableWebPagePreview, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelegramNotificationRuleBase {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    messageTemplate: ").append(toIndentedString(messageTemplate)).append("\n");
    sb.append("    parseMode: ").append(toIndentedString(parseMode)).append("\n");
    sb.append("    disableWebPagePreview: ").append(toIndentedString(disableWebPagePreview)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

