/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.TasksApi;
import com.influxdb.client.TasksQuery;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.LogEvent;
import com.influxdb.client.domain.Logs;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.Run;
import com.influxdb.client.domain.RunManually;
import com.influxdb.client.domain.Runs;
import com.influxdb.client.domain.Task;
import com.influxdb.client.domain.TaskCreateRequest;
import com.influxdb.client.domain.TaskStatusType;
import com.influxdb.client.domain.TaskUpdateRequest;
import com.influxdb.client.domain.Tasks;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.TasksService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class TasksApiImpl
extends AbstractRestClient
implements TasksApi {
    private static final Logger LOG = Logger.getLogger(TasksApiImpl.class.getName());
    private final TasksService service;

    TasksApiImpl(@Nonnull TasksService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Task findTaskByID(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Call<Task> call = this.service.getTasksID(taskID, null);
        return (Task)this.execute(call);
    }

    @Override
    @Nonnull
    public List<Task> findTasks() {
        return this.findTasks(null, null, null);
    }

    @Override
    @Nonnull
    public List<Task> findTasksByUser(@Nonnull User user) {
        Arguments.checkNotNull((Object)user, (String)"user");
        return this.findTasksByUserID(user.getId());
    }

    @Override
    @Nonnull
    public List<Task> findTasksByUserID(@Nullable String userID) {
        return this.findTasks(null, userID, null);
    }

    @Override
    @Nonnull
    public List<Task> findTasksByOrganization(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findTasksByOrganizationID(organization.getId());
    }

    @Override
    @Nonnull
    public List<Task> findTasksByOrganizationID(@Nullable String orgID) {
        return this.findTasks(null, null, orgID);
    }

    @Override
    @Nonnull
    public List<Task> findTasks(@Nullable String afterID, @Nullable String userID, @Nullable String orgID) {
        TasksQuery tasksQuery = new TasksQuery();
        tasksQuery.setAfter(afterID);
        tasksQuery.setUser(userID);
        tasksQuery.setOrgID(orgID);
        return this.findTasks(tasksQuery);
    }

    @Override
    @Nonnull
    public List<Task> findTasks(@Nonnull TasksQuery query) {
        Call<Tasks> call = this.service.getTasks(null, query.getName(), query.getAfter(), query.getUser(), query.getOrg(), query.getOrgID(), query.getStatus(), query.getLimit(), query.getType());
        Tasks tasks = (Tasks)this.execute(call);
        LOG.log(Level.FINEST, "findTasks found: {0}", tasks);
        return tasks.getTasks();
    }

    @Override
    @Nonnull
    public Stream<Task> findTasksStream(final @Nonnull TasksQuery query) {
        Iterator<Task> iterator = new Iterator<Task>(){
            private boolean hasNext = true;
            @Nonnull
            private Iterator<Task> tasksIterator = Collections.emptyIterator();
            @Nullable
            private String after = query.getAfter();

            @Override
            public boolean hasNext() {
                if (this.tasksIterator.hasNext()) {
                    return true;
                }
                if (this.hasNext) {
                    this.doQueryNext();
                    return this.tasksIterator.hasNext();
                }
                return false;
            }

            private void doQueryNext() {
                String nextUrl;
                Call<Tasks> call = TasksApiImpl.this.service.getTasks(null, query.getName(), this.after, query.getUser(), query.getOrg(), query.getOrgID(), query.getStatus(), query.getLimit(), query.getType());
                Tasks tasks = (Tasks)TasksApiImpl.this.execute(call);
                List<Task> tasksList = tasks.getTasks();
                this.tasksIterator = tasksList.iterator();
                if (!tasksList.isEmpty()) {
                    Task lastTask = tasksList.get(tasksList.size() - 1);
                    this.after = lastTask.getId();
                }
                this.hasNext = (nextUrl = tasks.getLinks().getNext()) != null && !nextUrl.isEmpty();
                String logMsg = "findTasksStream found: {0} has next page: {1} next after {2}: ";
                LOG.log(Level.FINEST, logMsg, new Object[]{tasks, this.hasNext, this.after});
            }

            @Override
            public Task next() throws IndexOutOfBoundsException {
                if (!this.tasksIterator.hasNext() && this.hasNext) {
                    this.doQueryNext();
                }
                if (this.tasksIterator.hasNext()) {
                    return this.tasksIterator.next();
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
        Stream<Task> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        return stream;
    }

    @Override
    @Nonnull
    public Task createTask(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        TaskCreateRequest request = new TaskCreateRequest();
        request.setFlux(task.getFlux());
        request.setOrgID(task.getOrgID());
        request.setOrg(task.getOrg());
        request.setDescription(task.getDescription());
        if (task.getStatus() != null) {
            request.setStatus(TaskStatusType.fromValue(task.getStatus().getValue()));
        }
        return this.createTask(request);
    }

    @Override
    @Nonnull
    public Task createTask(@Nonnull TaskCreateRequest taskCreateRequest) {
        Arguments.checkNotNull((Object)taskCreateRequest, (String)"taskCreateRequest");
        Call<Task> call = this.service.postTasks(taskCreateRequest, null);
        return (Task)this.execute(call);
    }

    @Override
    @Nonnull
    public Task createTaskCron(@Nonnull String name, @Nonnull String flux, @Nonnull String cron, @Nonnull Organization organization) {
        Arguments.checkNonEmpty((String)name, (String)"name of the task");
        Arguments.checkNonEmpty((String)flux, (String)"Flux script to run");
        Arguments.checkNonEmpty((String)cron, (String)"cron expression");
        Arguments.checkNotNull((Object)organization, (String)"organization");
        Task task = this.createTask(name, flux, null, cron, organization.getId());
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskCron(@Nonnull String name, @Nonnull String flux, @Nonnull String cron, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name of the task");
        Arguments.checkNonEmpty((String)flux, (String)"Flux script to run");
        Arguments.checkNonEmpty((String)cron, (String)"cron expression");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Task task = this.createTask(name, flux, null, cron, orgID);
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskEvery(@Nonnull String name, @Nonnull String flux, @Nonnull String every, @Nonnull Organization organization) {
        Arguments.checkNonEmpty((String)name, (String)"name of the task");
        Arguments.checkNonEmpty((String)flux, (String)"Flux script to run");
        Arguments.checkNonEmpty((String)every, (String)"every");
        Arguments.checkNotNull((Object)organization, (String)"organization");
        Task task = this.createTask(name, flux, every, null, organization.getId());
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task createTaskEvery(@Nonnull String name, @Nonnull String flux, @Nonnull String every, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name of the task");
        Arguments.checkNonEmpty((String)flux, (String)"Flux script to run");
        Arguments.checkNonEmpty((String)every, (String)"every expression");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Task task = this.createTask(name, flux, every, null, orgID);
        return this.createTask(task);
    }

    @Override
    @Nonnull
    public Task updateTask(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"Task is required");
        Arguments.checkDurationNotRequired((String)task.getEvery(), (String)"Task.every");
        TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
        taskUpdateRequest.setStatus(TaskStatusType.fromValue(task.getStatus().getValue()));
        taskUpdateRequest.setFlux(task.getFlux());
        taskUpdateRequest.setName(task.getName());
        taskUpdateRequest.setEvery(task.getEvery());
        taskUpdateRequest.setCron(task.getCron());
        taskUpdateRequest.setOffset(task.getOffset());
        taskUpdateRequest.setDescription(task.getDescription());
        return this.updateTask(task.getId(), taskUpdateRequest);
    }

    @Override
    @Nonnull
    public Task updateTask(@Nonnull String taskID, @Nonnull TaskUpdateRequest request) {
        Arguments.checkNotNull((Object)request, (String)"request");
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Call<Task> call = this.service.patchTasksID(taskID, request, null);
        return (Task)this.execute(call);
    }

    @Override
    public void deleteTask(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"Task is required");
        this.deleteTask(task.getId());
    }

    @Override
    public void deleteTask(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Call<Void> call = this.service.deleteTasksID(taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Task cloneTask(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Task task = this.findTaskByID(taskID);
        return this.cloneTask(task);
    }

    @Override
    @Nonnull
    public Task cloneTask(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        Task cloned = new Task();
        cloned.setName(task.getName());
        cloned.setOrgID(task.getOrgID());
        cloned.setFlux(task.getFlux());
        cloned.setStatus(TaskStatusType.ACTIVE);
        Task created = this.createTask(cloned);
        this.getLabels(task).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<ResourceMembers> call = this.service.getTasksIDMembers(taskID, null);
        ResourceMembers resourceMembers = (ResourceMembers)this.execute(call);
        LOG.log(Level.FINEST, "findTaskMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"Task");
        return this.getMembers(task.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        Arguments.checkNotNull((Object)member, (String)"member");
        return this.addMember(member.getId(), task.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postTasksIDMembers(taskID, user, null);
        return (ResourceMember)this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        Arguments.checkNotNull((Object)member, (String)"member");
        this.deleteMember(member.getId(), task.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<Void> call = this.service.deleteTasksIDMembersID(memberID, taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<ResourceOwners> call = this.service.getTasksIDOwners(taskID, null);
        ResourceOwners resourceMembers = (ResourceOwners)this.execute(call);
        LOG.log(Level.FINEST, "findTaskMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.getOwners(task.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        return this.addOwner(owner.getId(), task.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postTasksIDOwners(taskID, user, null);
        return (ResourceOwner)this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        this.deleteOwner(owner.getId(), task.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<Void> call = this.service.deleteTasksIDOwnersID(ownerID, taskID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.getRuns(task, null, null, null);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull Task task, @Nullable OffsetDateTime afterTime, @Nullable OffsetDateTime beforeTime, @Nullable Integer limit) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.getRuns(task.getId(), afterTime, beforeTime, limit);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        return this.getRuns(taskID, null, null, null);
    }

    @Override
    @Nonnull
    public List<Run> getRuns(@Nonnull String taskID, @Nullable OffsetDateTime afterTime, @Nullable OffsetDateTime beforeTime, @Nullable Integer limit) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<Runs> runs = this.service.getTasksIDRuns(taskID, null, null, limit, afterTime, beforeTime);
        Runs execute = (Runs)this.execute(runs);
        return execute.getRuns();
    }

    @Override
    @Nonnull
    public Run getRun(@Nonnull Run run) {
        Arguments.checkNotNull((Object)run, (String)"run");
        return this.getRun(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public Run getRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Arguments.checkNonEmpty((String)runID, (String)"Run.ID");
        Call<Run> run = this.service.getTasksIDRunsID(taskID, runID, null);
        return (Run)this.execute(run);
    }

    @Override
    @Nonnull
    public List<LogEvent> getRunLogs(@Nonnull Run run) {
        Arguments.checkNotNull((Object)run, (String)"run");
        return this.getRunLogs(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public List<LogEvent> getRunLogs(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Arguments.checkNonEmpty((String)runID, (String)"Run.ID");
        Call<Logs> call = this.service.getTasksIDRunsIDLogs(taskID, runID, null);
        Logs logs = (Logs)this.execute(call);
        return logs.getEvents();
    }

    @Override
    @Nonnull
    public Run runManually(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.runManually(task.getId(), new RunManually());
    }

    @Override
    @Nonnull
    public Run runManually(@Nonnull String taskId, @Nonnull RunManually runManually) {
        Arguments.checkNonEmpty((String)taskId, (String)"taskId");
        Arguments.checkNotNull((Object)runManually, (String)"runManually");
        Call<Run> call = this.service.postTasksIDRuns(taskId, null, runManually);
        return (Run)this.execute(call);
    }

    @Override
    @Nonnull
    public Run retryRun(@Nonnull Run run) {
        Arguments.checkNotNull((Object)run, (String)"run");
        return this.retryRun(run.getTaskID(), run.getId());
    }

    @Override
    @Nonnull
    public Run retryRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Arguments.checkNonEmpty((String)runID, (String)"Run.ID");
        Call<Run> run = this.service.postTasksIDRunsIDRetry(taskID, runID, null, "");
        return (Run)this.execute(run);
    }

    @Override
    public void cancelRun(@Nonnull Run run) {
        Arguments.checkNotNull((Object)run, (String)"run");
        this.cancelRun(run.getTaskID(), run.getId());
    }

    @Override
    public void cancelRun(@Nonnull String taskID, @Nonnull String runID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Arguments.checkNonEmpty((String)runID, (String)"Run.ID");
        Call<Void> run = this.service.deleteTasksIDRunsID(taskID, runID, null);
        this.execute(run);
    }

    @Override
    @Nonnull
    public List<LogEvent> getLogs(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.getLogs(task.getId());
    }

    @Override
    @Nonnull
    public List<LogEvent> getLogs(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"Task.ID");
        Call<Logs> execute = this.service.getTasksIDLogs(taskID, null);
        Logs logs = (Logs)this.execute(execute);
        return logs.getEvents();
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Task task) {
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.getLabels(task.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String taskID) {
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Call<LabelsResponse> call = this.service.getTasksIDLabels(taskID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull Task task) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)task, (String)"task");
        return this.addLabel(label.getId(), task.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postTasksIDLabels(taskID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Task task) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)task, (String)"task");
        this.deleteLabel(label.getId(), task.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String taskID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)taskID, (String)"taskID");
        Call<Void> call = this.service.deleteTasksIDLabelsID(taskID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private Task createTask(@Nonnull String name, @Nonnull String flux, @Nullable String every, @Nullable String cron, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name of the task");
        Arguments.checkNotNull((Object)flux, (String)"Flux script to run");
        Arguments.checkNonEmpty((String)orgID, (String)"Organization ID");
        Arguments.checkDurationNotRequired((String)every, (String)"Task.every");
        Task task = new Task();
        task.setName(name);
        task.setOrgID(orgID);
        task.setStatus(TaskStatusType.ACTIVE);
        task.setFlux(flux);
        String repetition = "";
        if (every != null) {
            repetition = repetition + "every: ";
            repetition = repetition + every;
        }
        if (cron != null) {
            repetition = repetition + "cron: ";
            repetition = repetition + "\"" + cron + "\"";
        }
        String fluxWithOptions = String.format("%s\n\noption task = {name: \"%s\", %s}", flux, name, repetition);
        task.setFlux(fluxWithOptions);
        return task;
    }
}

