/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.StackAssociations;
import com.influxdb.client.domain.StackLinks;
import com.influxdb.client.domain.TemplateKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * StackResources
 */

public class StackResources {
  public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
  @SerializedName(SERIALIZED_NAME_API_VERSION)
  private String apiVersion;

  public static final String SERIALIZED_NAME_RESOURCE_I_D = "resourceID";
  @SerializedName(SERIALIZED_NAME_RESOURCE_I_D)
  private String resourceID;

  public static final String SERIALIZED_NAME_KIND = "kind";
  @SerializedName(SERIALIZED_NAME_KIND)
  private TemplateKind kind = null;

  public static final String SERIALIZED_NAME_TEMPLATE_META_NAME = "templateMetaName";
  @SerializedName(SERIALIZED_NAME_TEMPLATE_META_NAME)
  private String templateMetaName;

  public static final String SERIALIZED_NAME_ASSOCIATIONS = "associations";
  @SerializedName(SERIALIZED_NAME_ASSOCIATIONS)
  private List<StackAssociations> associations = new ArrayList<>();

  public static final String SERIALIZED_NAME_LINKS = "links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private StackLinks links = null;

  public StackResources apiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return this;
  }

   /**
   * Get apiVersion
   * @return apiVersion
  **/
  public String getApiVersion() {
    return apiVersion;
  }

  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }

  public StackResources resourceID(String resourceID) {
    this.resourceID = resourceID;
    return this;
  }

   /**
   * Get resourceID
   * @return resourceID
  **/
  public String getResourceID() {
    return resourceID;
  }

  public void setResourceID(String resourceID) {
    this.resourceID = resourceID;
  }

  public StackResources kind(TemplateKind kind) {
    this.kind = kind;
    return this;
  }

   /**
   * Get kind
   * @return kind
  **/
  public TemplateKind getKind() {
    return kind;
  }

  public void setKind(TemplateKind kind) {
    this.kind = kind;
  }

  public StackResources templateMetaName(String templateMetaName) {
    this.templateMetaName = templateMetaName;
    return this;
  }

   /**
   * Get templateMetaName
   * @return templateMetaName
  **/
  public String getTemplateMetaName() {
    return templateMetaName;
  }

  public void setTemplateMetaName(String templateMetaName) {
    this.templateMetaName = templateMetaName;
  }

  public StackResources associations(List<StackAssociations> associations) {
    this.associations = associations;
    return this;
  }

  public StackResources addAssociationsItem(StackAssociations associationsItem) {
    if (this.associations == null) {
      this.associations = new ArrayList<>();
    }
    this.associations.add(associationsItem);
    return this;
  }

   /**
   * Get associations
   * @return associations
  **/
  public List<StackAssociations> getAssociations() {
    return associations;
  }

  public void setAssociations(List<StackAssociations> associations) {
    this.associations = associations;
  }

  public StackResources links(StackLinks links) {
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  public StackLinks getLinks() {
    return links;
  }

  public void setLinks(StackLinks links) {
    this.links = links;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StackResources stackResources = (StackResources) o;
    return Objects.equals(this.apiVersion, stackResources.apiVersion) &&
        Objects.equals(this.resourceID, stackResources.resourceID) &&
        Objects.equals(this.kind, stackResources.kind) &&
        Objects.equals(this.templateMetaName, stackResources.templateMetaName) &&
        Objects.equals(this.associations, stackResources.associations) &&
        Objects.equals(this.links, stackResources.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiVersion, resourceID, kind, templateMetaName, associations, links);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StackResources {\n");
    sb.append("    apiVersion: ").append(toIndentedString(apiVersion)).append("\n");
    sb.append("    resourceID: ").append(toIndentedString(resourceID)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    templateMetaName: ").append(toIndentedString(templateMetaName)).append("\n");
    sb.append("    associations: ").append(toIndentedString(associations)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

