/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Cancellable;
import com.influxdb.client.InfluxQLQueryApi;
import com.influxdb.client.domain.InfluxQLQuery;
import com.influxdb.client.service.InfluxQLQueryService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.InfluxQLQueryResult;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import retrofit2.Call;

public class InfluxQLQueryApiImpl
extends AbstractQueryApi
implements InfluxQLQueryApi {
    private final InfluxQLQueryService service;

    public InfluxQLQueryApiImpl(@Nonnull InfluxQLQueryService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQlQuery) {
        return this.query(influxQlQuery, null);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQlQuery, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        Call<ResponseBody> call = this.service.query(influxQlQuery.getCommand(), influxQlQuery.getDatabase(), influxQlQuery.getRetentionPolicy(), influxQlQuery.getPrecision() != null ? influxQlQuery.getPrecision().getSymbol() : null, null);
        AtomicReference atomicReference = new AtomicReference();
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                InfluxQLQueryResult result = this.parseResponse((BufferedSource)bufferedSource, (Cancellable)cancellable, valueExtractor);
                atomicReference.set(result);
            }
            catch (IOException e) {
                ERROR_CONSUMER.accept(e);
            }
        };
        this.query(call, consumer, ERROR_CONSUMER, EMPTY_ACTION, false);
        return (InfluxQLQueryResult)atomicReference.get();
    }

    private InfluxQLQueryResult parseResponse(@Nonnull BufferedSource bufferedSource, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        Arguments.checkNotNull((Object)bufferedSource, (String)"bufferedSource");
        try (InputStreamReader reader = new InputStreamReader(bufferedSource.inputStream(), StandardCharsets.UTF_8);){
            InfluxQLQueryResult influxQLQueryResult = InfluxQLQueryApiImpl.readInfluxQLResult(reader, cancellable, valueExtractor);
            return influxQLQueryResult;
        }
    }

    static InfluxQLQueryResult readInfluxQLResult(@Nonnull Reader reader, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        ArrayList<InfluxQLQueryResult.Result> results = new ArrayList<InfluxQLQueryResult.Result>();
        LinkedHashMap<String, InfluxQLQueryResult.Series> series = null;
        LinkedHashMap<String, Integer> headerCols = null;
        int nameCol = 0;
        int dynamicColumnsStartIndex = 2;
        try (CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT.builder().setIgnoreEmptyLines(false).build());){
            for (CSVRecord csvRecord : parser) {
                if (cancellable.isCancelled()) {
                    break;
                }
                int resultIndex = results.size();
                if (csvRecord.size() == 1 || csvRecord.get(0).equals("")) {
                    if (series != null) {
                        InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(resultIndex, new ArrayList(series.values()));
                        results.add(result);
                    }
                    series = null;
                    continue;
                }
                if (series == null) {
                    List header = csvRecord.toList();
                    headerCols = new LinkedHashMap<String, Integer>();
                    for (int col = dynamicColumnsStartIndex; col < header.size(); ++col) {
                        String colName = (String)header.get(col);
                        headerCols.put(colName, col - dynamicColumnsStartIndex);
                    }
                    series = new LinkedHashMap<String, InfluxQLQueryResult.Series>();
                    continue;
                }
                String name = csvRecord.get(nameCol);
                LinkedHashMap<String, Integer> finalHeaderCols = headerCols;
                InfluxQLQueryResult.Series serie = series.computeIfAbsent(name, n -> new InfluxQLQueryResult.Series(n, finalHeaderCols));
                Object[] values = headerCols.entrySet().stream().map(entry -> {
                    String value = csvRecord.get((Integer)entry.getValue() + dynamicColumnsStartIndex);
                    if (valueExtractor != null) {
                        return valueExtractor.extractValue((String)entry.getKey(), value, resultIndex, serie.getName());
                    }
                    return value;
                }).toArray();
                InfluxQLQueryResult.Series series2 = serie;
                Objects.requireNonNull(series2);
                InfluxQLQueryResult.Series.Record record = new InfluxQLQueryResult.Series.Record(series2, values);
                serie.addRecord(record);
            }
        }
        if (series != null) {
            InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(results.size(), new ArrayList(series.values()));
            results.add(result);
        }
        return new InfluxQLQueryResult(results);
    }
}

