/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write.events;

import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.utils.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class BackpressureEvent
extends AbstractWriteEvent {
    private final BackpressureReason reason;
    private static final Logger LOG = Logger.getLogger(BackpressureEvent.class.getName());

    public BackpressureEvent(@Nonnull BackpressureReason reason) {
        Arguments.checkNotNull((Object)((Object)reason), (String)"reason");
        this.reason = reason;
    }

    @Override
    public void logEvent() {
        LOG.log(Level.WARNING, String.format("Backpressure[%s] applied, try increase WriteOptions.bufferLimit", new Object[]{this.reason}));
    }

    @Nonnull
    public BackpressureReason getReason() {
        return this.reason;
    }

    public static enum BackpressureReason {
        FAST_EMITTING,
        TOO_MUCH_BATCHES;

    }
}

