/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.BucketShardMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * RestoredBucketMappings
 */

public class RestoredBucketMappings {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_SHARD_MAPPINGS = "shardMappings";
  @SerializedName(SERIALIZED_NAME_SHARD_MAPPINGS)
  private List<BucketShardMapping> shardMappings = new ArrayList<>();

  public RestoredBucketMappings id(String id) {
    this.id = id;
    return this;
  }

   /**
   * New ID of the restored bucket
   * @return id
  **/
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public RestoredBucketMappings name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RestoredBucketMappings shardMappings(List<BucketShardMapping> shardMappings) {
    this.shardMappings = shardMappings;
    return this;
  }

  public RestoredBucketMappings addShardMappingsItem(BucketShardMapping shardMappingsItem) {
    this.shardMappings.add(shardMappingsItem);
    return this;
  }

   /**
   * Get shardMappings
   * @return shardMappings
  **/
  public List<BucketShardMapping> getShardMappings() {
    return shardMappings;
  }

  public void setShardMappings(List<BucketShardMapping> shardMappings) {
    this.shardMappings = shardMappings;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestoredBucketMappings restoredBucketMappings = (RestoredBucketMappings) o;
    return Objects.equals(this.id, restoredBucketMappings.id) &&
        Objects.equals(this.name, restoredBucketMappings.name) &&
        Objects.equals(this.shardMappings, restoredBucketMappings.shardMappings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, shardMappings);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestoredBucketMappings {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    shardMappings: ").append(toIndentedString(shardMappings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

